// Uart_Test.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "Uart_Sample.h"

#include "../../Dll/HidDeviceSDKApi.h"

#ifdef _WIN64
#pragma comment(lib, "../../Dll/x64/HidDeviceSdk.lib")
#else
#pragma comment(lib, "../../Dll/x86/HidDeviceSdk.lib")
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// The one and only application object

CWinApp theApp;

using namespace std;

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		nRetCode = 1;
	}
	else
	{
		// TODO: code your application's behavior here.
		//Step1: Enum Device
		UINT nHidDeviceCount = 0;
		HANDLE m_hDeviceHandle = INVALID_HANDLE_VALUE;
		int nRet = 0;
		DWORD dwBaudRate = 115200;	//115200 bps
		UART_STOP_BIT nStopBit = UART_ONE_STOP_BIT;		// 1 Stop bit
		UART_PARITY_TYPE nParityType = UART_PARITY_NONE;	//None Parity
		UART_DATA_BIT nDataBit = UART_DATA_BIT_8;			//8 Data bits
		UART_FLOW_CONTROL nFlowControl = UART_DISABLE_FLOW_CONTROL;	//No Flow Control
		if( ERROR_SUCCESS == EnumDeviceByVid(&nHidDeviceCount, PROLIFIC_VID) ) {
			if(nHidDeviceCount > 0) {
				//Step2: Open Hid Device Array index, ex: 0
				nRet = OpenDeviceHandle(0, WINDEX_CH0_UART, &m_hDeviceHandle);
				if( ERROR_SUCCESS == nRet ) {
					//Step3: Set Uart Config
					nRet = SetUartConfig(m_hDeviceHandle, dwBaudRate, nStopBit, nParityType, nDataBit, nFlowControl);
					if( ERROR_SUCCESS == nRet ) {
						printf("SetUartConfig Pass!\n");
					} else {
						printf("SetUartConfig Fail!\n");
					}

					BYTE byWriteBuffer[]={0x30, 0x31, 0x32, 0x33, 0x34};
					BYTE byReadBuffer[64];
					UINT nNumberOfBytesToWrite = sizeof(byWriteBuffer);
					UINT nNumberOfBytesWritten = 0;
					DWORD dwTimeOutms = 2000; //2000 ms
					memset(byReadBuffer, 0, 64);
					//Step4: Write
					if(ERROR_SUCCESS == UartWrite(m_hDeviceHandle, &byWriteBuffer[0], nNumberOfBytesToWrite, 
												&nNumberOfBytesWritten, dwTimeOutms)) {
						printf("Write Uart Data: ");
						for(uint32_t n=0; n<5; n++) { 
							printf("0x%02X ", byWriteBuffer[n]);
						}
						printf("\n");
					} else {
						printf("Write Uart Data Fail!\n");
					}

					//Step5: Read
					UINT nNumberOfBytesToRead = sizeof(byWriteBuffer);
					UINT nNumberOfBytesRead = 0;
					if(ERROR_SUCCESS == UartRead(m_hDeviceHandle, &byReadBuffer[0], nNumberOfBytesToRead, 
												&nNumberOfBytesRead, dwTimeOutms)) {
						printf("Read Uart Data: ");
						for(uint32_t n=0; n<5; n++) { 
							printf("0x%02X ", byReadBuffer[n]);
						}
						printf("\n");
					} else {
						printf("Read Uart Data Fail!\n");
					}
				} else {
					printf("Open device Fail!\n");
				}
				//Step6: Close Hid Device
				nRet = CloseDeviceHandle(m_hDeviceHandle);
			} else {
				printf("No match Hid device!\n");
			}
		} else {
			printf("GetHidDeviceArrayByVid fail\n");
		}
	}
	system("pause");
	return nRetCode;
}
