// PWM_Sample.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "PWM_Sample.h"

#include "../../Dll/HidDeviceSDKApi.h"

#ifdef _WIN64
#pragma comment(lib, "../../Dll/x64/HidDeviceSdk.lib")
#else
#pragma comment(lib, "../../Dll/x86/HidDeviceSdk.lib")
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// The one and only application object

CWinApp theApp;

using namespace std;

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		nRetCode = 1;
	}
	else
	{
		//Step1: Enum Device
		uint32_t nHidDeviceCount = 0;
		HANDLE hDeviceHandle = INVALID_HANDLE_VALUE;
		int32_t nRet = 0;
		if( ERROR_SUCCESS == EnumDeviceByVid(&nHidDeviceCount, PROLIFIC_VID) ) {
			if(nHidDeviceCount > 0) {
				//Step2: Open Hid Device Array index, ex: 0
				nRet = OpenDeviceHandle(0, WINDEX_CH0_UART, &hDeviceHandle);
				if( ERROR_SUCCESS == nRet ) {
					//P0-4
					//PWM Duty: HIGH:LOW = nDuty :(256-nDuty), 0x00 or 0xFF:turn off PWM
					//PWM Period: Base Clock = 8000 KHZ, Period= (1/(512*(nPeriod+1))*8000 KHz
					//nPeriod =1, PWM Period= (1/(512*2))*8000 KHz = 7.8125 KHz
					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP4_DTR, 128, 1);
					//Period = 254, PWMPeriod = (1/(512*(255))*8000 KHz = 61.27 Hz
					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP4_DTR, 128, 254);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP4_DTR, 128, 128);
					//Stop PWM(nDuty or nPeriod = (0x00 or 0xFF))
					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP4_DTR, 0, 0);

					//nRet = SetGPIODir(hDeviceHandle, WINDEX_CH0_UART, GP4_DTR, GPIO_OUPUT_DIR);
					//nRet = SetGPIO(hDeviceHandle, WINDEX_CH0_UART, GP4_DTR, GPIO_HIGH);

					//P0-6
					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP6_DCD, 128, 1);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP6_DCD, 128, 254);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP6_DCD, 128, 128);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP6_DCD, 0, 128);

					//nRet = SetGPIODir(hDeviceHandle, WINDEX_CH0_UART, GP6_DCD, GPIO_OUPUT_DIR);
					//nRet = SetGPIO(hDeviceHandle, WINDEX_CH0_UART, GP6_DCD, GPIO_HIGH);

					//P0-3
					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP3_CTS, 128, 1);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP3_CTS, 128, 254);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP3_CTS, 128, 128);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP3_CTS, 0, 128);

					//P0-5
					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP5_DSR, 128, 1);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP5_DSR, 128, 254);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP5_DSR, 128, 128);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH0_UART, GP5_DSR, 0, 128);

					//P1-3
					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH1_I2C, GP3_CTS, 128, 1);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH1_I2C, GP3_CTS, 128, 254);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH1_I2C, GP3_CTS, 128, 128);

					nRet = SetPwmDutyPeriod(hDeviceHandle, WINDEX_CH1_I2C, GP3_CTS, 0, 128);
				} else {
					printf("Open device Fail!\n");
				}
				//Step6: Close Hid Device
				nRet = CloseDeviceHandle(hDeviceHandle);
			} else {
				printf("No match Hid device!\n");
			}
		} else {
			printf("GetHidDeviceArrayByVid fail\n");
		}
	}
	system("pause");
	return nRetCode;
}
