// I2C_Sample.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "I2C_Sample.h"

#include "../../Dll/HidDeviceSDKApi.h"

#ifdef _WIN64
#pragma comment(lib, "../../Dll/x64/HidDeviceSdk.lib")
#else
#pragma comment(lib, "../../Dll/x86/HidDeviceSdk.lib")
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// The one and only application object

CWinApp theApp;

using namespace std;

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		nRetCode = 1;
	}
	else
	{
		// TODO: code your application's behavior here.
		//Step1: Enum Device
		uint32_t nHidDeviceCount = 0;
		HANDLE hDeviceHandle = INVALID_HANDLE_VALUE;
		int32_t nRet = 0;
		if( ERROR_SUCCESS == EnumDeviceByVid(&nHidDeviceCount, PROLIFIC_VID) ) {
			if(nHidDeviceCount > 0) {
				//Step2: Open Hid Device Array index, ex: 0
				nRet = OpenDeviceHandle(0, WINDEX_CH1_I2C, &hDeviceHandle);
				if( ERROR_SUCCESS == nRet ) {
					//Step3: Set I2C Frequency
					//byI2CFreqDiv = 4, I2C Frequency(KHz) = 24000/4 KHz= 6 Mhz(Max)
					//byI2CFreqDiv = 255, I2C Frequency(KHz) = 24000/254 = 94 Khz(Min)
					uint8_t byI2CFreqDiv = 100;	//I2C Frequency(KHz) = 24000/100 KHz= 240 KHz
					nRet = SetI2CFrequency(hDeviceHandle, byI2CFreqDiv);
					if(ERROR_SUCCESS == nRet) {
						printf("Set I2C Frequency=%d Hz\n", 24000000/byI2CFreqDiv);
					} else {
						printf("SetI2CFrequency Fail!\n");
					}

					//Set I2C Address(7 Bit Device Address)
					uint8_t by7BitDeviceAddress = 0xA0;
					//Step4: AT24C02, PageWrite Command
					//Send I2C Word Address 0x00, Data = {0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37};
					uint8_t byWriteBuffer[8]={0x00, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37};
					uint8_t nHidWritePacketSize = 8;
					uint16_t nRealDataLen = 0;
					uint32_t nTimeOutMs = 1000;	//Unit: ms
					nRet = I2CWrite(hDeviceHandle, by7BitDeviceAddress, &byWriteBuffer[0], nHidWritePacketSize, 
									&nRealDataLen, nTimeOutMs);
					if(ERROR_SUCCESS <= nRet) {
						printf("I2C Page Write, WordAddress=0x%x, Data=", byWriteBuffer[0]);
						for(uint32_t n=1; n<8; n++) { 
							printf("0x%02X ", byWriteBuffer[n]);
						}
						printf("\n");
					} else {
						printf("I2C PageWrite Fail!, ErrorCode=%d\n", nRet);
					}
			
					//Step5: AT24C02, Random Read Command
					uint8_t byWordAddress[1]={0x00};	//I2C Start Word Address
					nHidWritePacketSize = 0x01;
					uint16_t nNumberOfBytesToRead = 7;
					uint8_t byReadBuffer[7];
					nRet = I2CWriteRead(hDeviceHandle, by7BitDeviceAddress, &byWordAddress[0], nHidWritePacketSize, 
										&byReadBuffer[0], nNumberOfBytesToRead, &nRealDataLen, nTimeOutMs);
					if(ERROR_SUCCESS <= nRet) {
						printf("I2C Random Read, WordAddress=0x%x, Data=", byWordAddress[0]);
						for(uint32_t n=0; n<7; n++) { 
							printf("0x%02X ", byReadBuffer[n]);
						}
						printf("\n");
					} else {
						printf("I2C Random Read Fail!, ErrorCode=%d\n", nRet);
					}
				} else {
					printf("Open device Fail!\n");
				}
				//Step6: Close Hid Device
				nRet = CloseDeviceHandle(hDeviceHandle);
			} else {
				printf("No match Hid device!\n");
			}
		} else {
			printf("GetHidDeviceArrayByVid fail\n");
		}
	}
	system("pause");
	return nRetCode;
}
