#ifndef _LIB_PL233X_236X_
#define _LIB_PL233X_236X_
///////////////////////////////////////////////////////////////////////////////
////Copyright (c) 2018 Prolific Technology Inc. All rights reserved.
///////////////////////////////////////////////////////////////////////////////

#ifdef HIDSDK_EXPORTS
#define HIDSDK_API __declspec(dllexport)
#else
#define HIDSDK_API __declspec(dllimport)
#endif

#pragma once

#ifdef __cplusplus
extern "C" {
#endif

typedef void					*HANDLE;
typedef unsigned char			uint8_t;	//1 bytes
typedef unsigned short			uint16_t;	//2 bytes
typedef unsigned int			uint32_t;	//4 bytes
typedef unsigned long long      uint64_t;	//8 bytes

typedef signed char             int8_t;		//1 bytes
typedef short                   int16_t;	//2 bytes	
typedef int                     int32_t;	//4 bytes
typedef long long               int64_t;	//8 bytes

#define PROLIFIC_VID			0x067B
#define PL_ERROR_SUCCESS				0
#define PL_ERROR_INSUFFICIENT_BUFFER	-1
#define PL_ERROR_READ_REGISTER_FAIL		-2
#define PL_ERROR_WRITE_REGISTER_FAIL	-3
#define PL_ERROR_READ_FAIL				-4
#define PL_ERROR_READ_TIMEOUT			-5
#define PL_ERROR_WRITE_FAIL				-6
#define PL_ERROR_WRITE_TIMEOUT			-7
#define PL_ERROR_DEVICE_NOT_EXIST		-8
#define PL_ERROR_NOT_GPIO_PIN			-9
#define PL_ERROR_DEVICE_OPEN_FAIL       -10
#define PL_ERROR_DATA_LENGTH_TOO_LARGE  -11
#define	PL_ERROR_SET_GPIO_FAIL			-12
#define PL_ERROR_I2C_BUS_BUSY			-13
#define PL_ERROR_I2C_ADDRESS_NACK		-14
#define PL_ERROR_I2C_DATA_NACK			-15
#define PL_ERROR_I2C_PROCESSING			-16
#define	PL_ERROR_OTHER_FAIL				-99

#define BIT0       0x01
#define BIT1       0x02
#define BIT2       0x04
#define BIT3       0x08
#define BIT4       0x10
#define BIT5       0x20
#define BIT6       0x40
#define BIT7       0x80

enum CHANNEL_SELECT {
	WINDEX_CH0_UART = 0x00,
	WINDEX_CH1_I2C = 0x01,
	WINDEX_CH2_SPI = 0x02,
	WINDEX_CH3 = 0x03,
};

enum SPI_SELECT {
	SPI_SELECT0 = 0,
	SPI_SELECT1 = 1,
	SPI_SELECT2 = 2,
	SPI_SELECT3 = 3
};

enum SPI_MODE {
	SPI_MODE0 = 0x00,	//Mode 0
	SPI_MODE1 = 0x01,	//Mode 1,
	SPI_MODE2 = 0x02,	//Mode 2,
	SPI_MODE3 = 0x03,	//Mode 3
};

//UART_FLOW_CONTROL MODE
enum UART_FLOW_CONTROL {
	UART_RTS_CTS_DTR_DSR_FLOW_CONTROL = 0x0F,
	UART_DTR_DSR_FLOW_CONTROL = 0x0C,
	UART_RTS_CTS_FLOW_CONTROL = 0x03,
	UART_SW_FLOW_CONTROL = 0x40,
	UART_DISABLE_FLOW_CONTROL = 0x00,
};

//STOP BIT
enum UART_STOP_BIT {
	UART_ONE_STOP_BIT = 0,
	UART_ONE_POINT_FIVE_STOP_BIT = 1,
	UART_TWO_STOP_BIT = 2,
};

//PARITY
enum UART_PARITY_TYPE {
	UART_PARITY_NONE = 0,
	UART_PARITY_ODD = 1,
	UART_PARITY_EVEN = 2,
	UART_PARITY_MARK = 3,
	UART_PARITY_SPACE = 4,
};

//DATA BIT
enum UART_DATA_BIT {
	UART_DATA_BIT_5 = 5,
	UART_DATA_BIT_6 = 6,
	UART_DATA_BIT_7 = 7,
	UART_DATA_BIT_8 = 8,
};

//GPIO
enum PL25xx_GPIO_PIN {
	GP2_RTS = 0x02,
	GP3_CTS = 0x03,
	GP4_DTR = 0x04,
	GP5_DSR = 0x05,
	GP6_DCD = 0x06,
	GP7_RI = 0x07,
	GP10 = 0x0A,
};

enum PL25xx_GPIO_DIR {
	GPIO_INPUT_DIR = 0,
	GPIO_OUPUT_DIR = 1,
	RESTORE_DEFAULT = 2,
};

enum PL25xx_GPIO_VALUE {
	GPIO_LOW = 0,
	GPIO_HIGH = 1,
};

//SDK Version
HIDSDK_API int32_t WINAPI GetSDKVersion(uint32_t* SDKVersion); 

//Device API Start
HIDSDK_API int32_t WINAPI GetVidPidByIndex(uint32_t DeviceIndex, uint16_t* VID, uint16_t* PID);
HIDSDK_API int32_t WINAPI GetVidPidSerialNumberByIndex(uint32_t DeviceIndex, uint16_t* VID, uint16_t* PID, 
							wchar_t* SerialNumber, uint8_t Length);
HIDSDK_API int32_t WINAPI EnumDeviceByVid(uint32_t* HidDeviceCount, uint16_t VID);
HIDSDK_API int32_t WINAPI EnumDeviceByVidPid(uint32_t* HidDeviceCount, uint16_t VID, uint16_t PID);
HIDSDK_API int32_t WINAPI OpenDeviceHandle(uint32_t DeviceIndex, CHANNEL_SELECT nChannelSelect, HANDLE* hDeviceHandle);
HIDSDK_API int32_t WINAPI CloseDeviceHandle(HANDLE hDeviceHandle);
//Device API End

//UART API Start
HIDSDK_API int32_t WINAPI GetUartConfig(HANDLE hDeviceHandle, uint32_t* BaudRate, UART_STOP_BIT* StopBit, 
					UART_PARITY_TYPE* ParityType, UART_DATA_BIT* Databit, UART_FLOW_CONTROL* FlowControl);
HIDSDK_API int32_t WINAPI SetUartConfig(HANDLE hDeviceHandle, uint32_t BaudRate, UART_STOP_BIT StopBit, 
					UART_PARITY_TYPE ParityType, UART_DATA_BIT Databit, UART_FLOW_CONTROL FlowControl);
HIDSDK_API int32_t WINAPI UartRead(HANDLE hDeviceHandle, uint8_t* ReadBuffer, uint32_t NumberOfBytesToRead, 
									uint32_t* NumberOfBytesRead, uint32_t TimeOutms);
HIDSDK_API int32_t WINAPI UartWrite(HANDLE hDeviceHandle, uint8_t* WriteBuffer, uint32_t NumberOfBytesToWrite, 
									uint32_t* NumberOfBytesWritten, uint32_t TimeOutms);
HIDSDK_API int32_t WINAPI SetXonXoffSymbol(HANDLE hDeviceHandle, uint8_t Xon, uint8_t Xoff);
HIDSDK_API int32_t WINAPI UartReset(HANDLE hDeviceHandle);
//UART API End

//I2C API Start
HIDSDK_API int32_t WINAPI SetI2CFrequency(HANDLE hDeviceHandle, uint8_t FreqDiv);

HIDSDK_API int32_t WINAPI I2CRead(HANDLE hDeviceHandle, uint8_t DeviceAddr, uint8_t* ReadBuffer, uint16_t NumberOfBytesToRead, 
								  uint16_t* NumberOfBytesRead, uint32_t TimeOutms);
HIDSDK_API int32_t WINAPI I2CWrite(HANDLE hDeviceHandle, uint8_t DeviceAddr, uint8_t* WriteBuffer, uint16_t NumberOfBytesToWrite, 
									uint16_t* NumberOfBytesWritten, uint32_t TimeOutms);
HIDSDK_API int32_t WINAPI I2CWriteRead(HANDLE hDeviceHandle, uint8_t DeviceAddr, uint8_t* WriteBuffer, uint16_t NumberOfBytesToWrite, 
									BYTE* byReadBuffer, WORD NumberOfBytesToRead, WORD* nNumberOfBytesUse, uint32_t TimeOutms);

HIDSDK_API int32_t WINAPI I2CReset(HANDLE hDeviceHandle);
//I2C API End

//SPI API Start
HIDSDK_API int32_t WINAPI SetSPIFrequency(HANDLE hDeviceHandle, uint8_t FreqDiv, SPI_MODE spiMode);
HIDSDK_API int32_t WINAPI SPIRead(HANDLE hDeviceHandle, SPI_SELECT SPISelect, uint8_t* ReadBuffer, 
								uint16_t NumberOfBytesToRead, uint16_t* NumberOfBytesRead, uint32_t TimeOutms);
HIDSDK_API int32_t WINAPI SPIWrite(HANDLE hDeviceHandle, SPI_SELECT SPISelect, uint8_t* WriteBuffer,
								uint16_t NumberOfBytesToWrite, uint16_t* NumberOfBytesWritten, uint32_t TimeOutms);
HIDSDK_API int32_t WINAPI SPIWriteRead(HANDLE hDeviceHandle, SPI_SELECT nSelectSPI, uint8_t* WriteBuffer, uint16_t NumberOfBytesToWrite, 
									BYTE* byReadBuffer, WORD NumberOfBytesToRead, WORD* nNumberOfBytesUse, uint32_t TimeOutms);

HIDSDK_API int32_t WINAPI SPIReset(HANDLE hDeviceHandle);
//SPI API End

//GPIO API Start
HIDSDK_API int32_t WINAPI SetGPIODir(HANDLE hDeviceHandle, CHANNEL_SELECT nChannelSelect, PL25xx_GPIO_PIN nGPIOPin, PL25xx_GPIO_DIR nGPIODir);
HIDSDK_API int32_t WINAPI SetGPIO(HANDLE hDeviceHandle, CHANNEL_SELECT nChannelSelect, PL25xx_GPIO_PIN GPIOPin, PL25xx_GPIO_VALUE Value);
HIDSDK_API int32_t WINAPI GetGPIO(HANDLE hDeviceHandle, CHANNEL_SELECT nChannelSelect, PL25xx_GPIO_PIN GPIOPin, PL25xx_GPIO_VALUE* Value);
//GPIO Function End

//PWM API Start
HIDSDK_API int32_t WINAPI SetClockDiv(HANDLE hDeviceHandle, uint8_t nDivValue);
HIDSDK_API int32_t WINAPI SetPwmDutyPeriod(HANDLE hDeviceHandle, CHANNEL_SELECT nIndexChannelSelect, PL25xx_GPIO_PIN GPIOPin, uint8_t nDuty, uint8_t nPeriod);
//PWM API End

#ifdef __cplusplus
}
#endif

#endif