// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the PL2303DLL_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// PL2303DLL_API functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.
#ifdef PL2303DLL_EXPORTS
#define PL2303DLL_API __declspec(dllexport)
#else
#define PL2303DLL_API __declspec(dllimport)
#endif

// This class is exported from the PL2303DLL.dll
class PL2303DLL_API CPL2303DLL {
public:
	CPL2303DLL(void);
	// TODO: add your methods here.
};

extern PL2303DLL_API int nPL2303DLL;

PL2303DLL_API int fnPL2303DLL(void);


// Status code
#define STATUS_SUCCESS							0
#define STATUS_OPEN_FAIL						1
#define STATUS_ALREADY_OPEN_FAIL		2
#define SATATUS_EEPROM_NOT_OPEN			3
#define STATUS_WRITE_ZERO_LEN				4
#define STATUS_WRITE_EEPROM_FAIL		5
#define STATUS_WRITE_BELOW_FAIL			6
#define STATUS_WRITE_OVERFLOW_FAIL	7
#define STATUS_READ_ZERO_LEN				8
#define STATUS_READ_EEPROM_FAIL			9
#define STATUS_READ_BELOW_FAIL			10
#define STATUS_READ_OVERFLOW_FAIL		11
#define STATUS_CheckChip_FAIL		12
#define STATUS_Chip_No_Support		13
#define STATUS_Check_EEPROM_Space_FAIL 14
#define STATUS_NoEEPROM_SPACE           15
#define STATUS_EEPROM_NO_Programmed      16

        
#define STATUS_GPIO_NUMBER_OVERRANGE      17
#define STATUS_GPIO_ENABLE_FAIL      18
#define STATUS_GPIO_SetValue_FAIL      19
#define STATUS_GPIO_GetValue_FAIL    20
#define STATUS_Port_Is_Not_Opened    21
#define STATUS_PWM_Value_Error    22

#define STATUS_Clock_Output_ENABLE_FAIL     23
#define STATUS_Clock_Output_SET_FAIL     24

#define STATUS_LED_Output_ENABLE_FAIL     25
#define STATUS_LED_Output_SET_FAIL     26

#define STATUS_PWM_Output_SET_FAIL     27

#define STATUS_GPIO_Number_OverRange 28

PL2303DLL_API int PL2303_OpenEEPROM(char *comStr);
PL2303DLL_API int PL2303_Read_EEPROM(BYTE *buff);
PL2303DLL_API int PL2303_Write_EEPROM(BYTE *buff);
PL2303DLL_API int PL2303_CloseEEPROM(void);
// Functions

PL2303DLL_API int PL2303_Read_EEPROM_H(HANDLE hPL2303HXD,BYTE *buff);
PL2303DLL_API int PL2303_Write_EEPROM_H(HANDLE hPL2303HXD,BYTE *buff);

//PL2303TB
PL2303DLL_API int PL2303_Open(char *comStr);
PL2303DLL_API int PL2303_Close(void);

//PL2303TB 12 GPIO
PL2303DLL_API int PL2303_12GPIO_ENABLE(HANDLE hdrv, __int8 GPIO_Num, BOOL Enable);
PL2303DLL_API int PL2303_12GPIO_SetValue(HANDLE hdrv, __int8 GPIO_Num, BYTE val);
PL2303DLL_API int PL2303_12GPIO_GetValue(HANDLE hdrv, __int8 GPIO_Num, BYTE *val);


//PL2303TB CLOCK
PL2303DLL_API int PL2303_Enable_Clock_Output(HANDLE hdrv, __int8 Clock_IO_Num, BOOL Enable);
PL2303DLL_API int PL2303_SetClock(HANDLE hdrv, __int8 Clock_IO_Num, BYTE val);


//PL2303TB LED
PL2303DLL_API int PL2303_Enable_LED_Output(HANDLE hdrv, __int8 LED_IO_Num, BOOL Enable);
PL2303DLL_API int PL2303_SetLED(HANDLE hdrv, __int8 LED_IO_Num, BYTE val);

//PL2303TB PWM
PL2303DLL_API int PL2303_Set_PWM_Output(HANDLE hdrv, __int8 PWM_IO_Num,BYTE *buff);

//PL2543 11 GPIO
PL2303DLL_API int PL2543_11GPIO_CE_Config(HANDLE m_hCOM, BYTE PortNumber, BYTE Channel, BOOL enable);
PL2303DLL_API int PL2543_11GPIO_OE_Config(HANDLE m_hCOM, BYTE PortNumber, BYTE Channel, BOOL enable);
PL2303DLL_API int PL2543_11GPIO_GET_Config(HANDLE m_hCOM, BYTE PortNumber, BYTE Channel, BYTE *val);
PL2303DLL_API int PL2543_11GPIO_SET_Config(HANDLE m_hCOM, BYTE i_wValue, BYTE i_wIndex, BYTE val);
