﻿
// PL2543_11GPIODlg.cpp: 實作檔案
//

#include "pch.h"
#include "framework.h"
#include "PL2543_11GPIO.h"
#include "PL2543_11GPIODlg.h"
#include "afxdialogex.h"
#include <winioctl.h>
#include "Ioctl.h"
//#include "..\PL2303DLL\PL2303DLL.h"
#include "inc_PL2303\x86\PL2303DLL.h"


#ifdef _WIN64
#pragma comment(lib, "inc_PL2303/x64/PL2303DLL.lib")
#else
#pragma comment(lib, "inc_PL2303/x86/PL2303DLL.lib")
#endif


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// 對 App About 使用 CAboutDlg 對話方塊

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// 對話方塊資料
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支援

// 程式碼實作
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CPL254311GPIODlg 對話方塊



CPL254311GPIODlg::CPL254311GPIODlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_PL2543_11GPIO_DIALOG, pParent)
	, mv_P1_10_edit(0)
	, mv_P2_10_edit(_T("0"))
	, mv_P3_10_edit(0)
	, mv_TX_LED0_edit(_T("0"))
	, mv_RX_LED0_edit(_T("0"))
	, mv_TX_LED1_edit(0)
	, mv_RX_LED1_edit(0)
	, mv_TX_LED2_edit(_T("0"))
	, mv_RX_LED2_edit(0)
	, mv_TX_LED3_edit(0)
	, mv_RX_LED3_edit(_T("0"))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPL254311GPIODlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CHK_P1_10_CE, mc_P1_10_CE);
	DDX_Control(pDX, IDC_CHK_P1_10_OE, mc_P1_10_OE);
	DDX_Control(pDX, IDC_BTN_Get_P1_10, mc_P1_10_Get);
	DDX_Control(pDX, IDC_BTN_Set_P1_10, mc_P1_10_Set);
	DDX_Control(pDX, IDC_EDIT_SetValue_P1_10, mc_P1_10_edit);
	DDX_Text(pDX, IDC_EDIT_SetValue_P1_10, mv_P1_10_edit);
	DDX_Control(pDX, IDC_CHK_P2_10_CE, mc_P2_10_CE);
	DDX_Control(pDX, IDC_CHK_P2_10_OE, mc_P2_10_OE);
	DDX_Control(pDX, IDC_BTN_Get_P2_10, mc_P2_10_Get);
	DDX_Control(pDX, IDC_BTN_Set_P2_10, mc_P2_10_Set);
	DDX_Control(pDX, IDC_EDIT_SetValue_P2_10, mc_P2_10_edit);
	DDX_Text(pDX, IDC_EDIT_SetValue_P2_10, mv_P2_10_edit);
	DDX_Control(pDX, IDC_CHK_P3_10_CE, mc_P3_10_CE);
	DDX_Control(pDX, IDC_CHK_P3_10_OE, mc_P3_10_OE);
	DDX_Control(pDX, IDC_BTN_Get_P3_10, mc_P3_10_Get);
	DDX_Control(pDX, IDC_BTN_Set_P3_10, mc_P3_10_Set);
	DDX_Control(pDX, IDC_EDIT_SetValue_P3_10, mc_P3_10_edit);
	DDX_Text(pDX, IDC_EDIT_SetValue_P3_10, mv_P3_10_edit);
	DDX_Control(pDX, IDC_CHK_TX_LED0_CE, mc_TX_LED0_CE);
	DDX_Control(pDX, IDC_CHK_TX_LED0_OE, mc_TX_LED0_OE);
	DDX_Control(pDX, IDC_BTN_Get_TX_LED0, mc_TX_LED0_Get);
	DDX_Control(pDX, IDC_BTN_Set_TX_LED0, mc_TX_LED0_Set);
	DDX_Control(pDX, IDC_EDIT_SetValue_TX_LED0, mc_TX_LED0_edit);
	DDX_Text(pDX, IDC_EDIT_SetValue_TX_LED0, mv_TX_LED0_edit);
	DDX_Control(pDX, IDC_CHK_RX_LED0_CE, mc_RX_LED0_CE);
	DDX_Control(pDX, IDC_CHK_RX_LED0_OE, mc_RX_LED0_OE);
	DDX_Control(pDX, IDC_BTN_Get_RX_LED0, mc_RX_LED0_Get);
	DDX_Control(pDX, IDC_BTN_Set_RX_LED0, mc_RX_LED0_Set);
	DDX_Control(pDX, IDC_EDIT_SetValue_RX_LED0, mc_RX_LED0_edit);
	DDX_Text(pDX, IDC_EDIT_SetValue_RX_LED0, mv_RX_LED0_edit);
	DDX_Control(pDX, IDC_CHK_TX_LED1_CE, mc_TX_LED1_CE);
	DDX_Control(pDX, IDC_CHK_TX_LED1_OE, mc_TX_LED1_OE);
	DDX_Control(pDX, IDC_BTN_Get_TX_LED1, mc_TX_LED1_Get);
	DDX_Control(pDX, IDC_BTN_Set_TX_LED1, mc_TX_LED1_Set);
	DDX_Control(pDX, IDC_EDIT_SetValue_TX_LED1, mc_TX_LED1_edit);
	DDX_Text(pDX, IDC_EDIT_SetValue_TX_LED1, mv_TX_LED1_edit);
	DDX_Control(pDX, IDC_CHK_RX_LED1_CE, mc_RX_LED1_CE);
	DDX_Control(pDX, IDC_CHK_RX_LED1_OE, mc_RX_LED1_OE);
	DDX_Control(pDX, IDC_BTN_Get_RX_LED1, mc_RX_LED1_Get);
	DDX_Control(pDX, IDC_BTN_Set_RX_LED1, mc_RX_LED1_Set);
	DDX_Control(pDX, IDC_EDIT_SetValue_RX_LED1, mc_RX_LED1_edit);
	DDX_Text(pDX, IDC_EDIT_SetValue_RX_LED1, mv_RX_LED1_edit);
	DDX_Control(pDX, IDC_CHK_TX_LED2_CE, mc_TX_LED2_CE);
	DDX_Control(pDX, IDC_CHK_TX_LED2_OE, mc_TX_LED2_OE);
	DDX_Control(pDX, IDC_BTN_Get_TX_LED2, mc_TX_LED2_Get);
	DDX_Control(pDX, IDC_BTN_Set_TX_LED2, mc_TX_LED2_Set);
	DDX_Control(pDX, IDC_EDIT_SetValue_TX_LED2, mc_TX_LED2_edit);
	DDX_Text(pDX, IDC_EDIT_SetValue_TX_LED2, mv_TX_LED2_edit);
	DDX_Control(pDX, IDC_CHK_RX_LED2_CE, mc_RX_LED2_CE);
	DDX_Control(pDX, IDC_CHK_RX_LED2_OE, mc_RX_LED2_OE);
	DDX_Control(pDX, IDC_BTN_Get_RX_LED2, mc_RX_LED2_Get);
	DDX_Control(pDX, IDC_BTN_Set_RX_LED2, mc_RX_LED2_Set);
	DDX_Control(pDX, IDC_EDIT_SetValue_RX_LED2, mc_RX_LED2_edit);
	DDX_Text(pDX, IDC_EDIT_SetValue_RX_LED2, mv_RX_LED2_edit);
	DDX_Control(pDX, IDC_CHK_TX_LED3_CE, mc_TX_LED3_CE);
	DDX_Control(pDX, IDC_CHK_TX_LED3_OE, mc_TX_LED3_OE);
	DDX_Control(pDX, IDC_BTN_Get_TX_LED3, mc_TX_LED3_Get);
	DDX_Control(pDX, IDC_BTN_Set_TX_LED3, mc_TX_LED3_Set);
	DDX_Control(pDX, IDC_EDIT_SetValue_TX_LED3, mc_TX_LED3_edit);
	DDX_Text(pDX, IDC_EDIT_SetValue_TX_LED3, mv_TX_LED3_edit);
	DDX_Control(pDX, IDC_CHK_RX_LED3_CE, mc_RX_LED3_CE);
	DDX_Control(pDX, IDC_CHK_RX_LED3_OE, mc_RX_LED3_OE);
	DDX_Control(pDX, IDC_BTN_Get_RX_LED3, mc_RX_LED3_Get);
	DDX_Control(pDX, IDC_BTN_Set_RX_LED3, mc_RX_LED3_Set);
	DDX_Control(pDX, IDC_EDIT_SetValue_RX_LED3, mc_RX_LED3_edit);
	DDX_Text(pDX, IDC_EDIT_SetValue_RX_LED3, mv_RX_LED3_edit);
}

BEGIN_MESSAGE_MAP(CPL254311GPIODlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CHK_P1_10_CE, &CPL254311GPIODlg::OnBnClickedChkP110Ce)
	ON_BN_CLICKED(IDC_CHK_P1_10_OE, &CPL254311GPIODlg::OnBnClickedChkP110Oe)
	ON_BN_CLICKED(IDC_BUTTON_Clear, &CPL254311GPIODlg::OnBnClickedButtonClear)
	ON_BN_CLICKED(IDC_CHK_P2_10_CE, &CPL254311GPIODlg::OnBnClickedChkP210Ce)
	ON_BN_CLICKED(IDC_CHK_P2_10_OE, &CPL254311GPIODlg::OnBnClickedChkP210Oe)
	ON_BN_CLICKED(IDC_BUTTON1, &CPL254311GPIODlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BTN_OPEN, &CPL254311GPIODlg::OnBnClickedBtnOpen)
	ON_BN_CLICKED(IDC_BTN_Get_P1_10, &CPL254311GPIODlg::OnBnClickedBtnGetP110)
	ON_BN_CLICKED(IDC_BTN_Set_P1_10, &CPL254311GPIODlg::OnBnClickedBtnSetP110)
	ON_BN_CLICKED(IDC_BTN_Get_P2_10, &CPL254311GPIODlg::OnBnClickedBtnGetP210)
	ON_BN_CLICKED(IDC_BTN_Set_P2_10, &CPL254311GPIODlg::OnBnClickedBtnSetP210)
	ON_BN_CLICKED(IDC_CHK_P3_10_CE, &CPL254311GPIODlg::OnBnClickedChkP310Ce)
	ON_BN_CLICKED(IDC_CHK_P3_10_OE, &CPL254311GPIODlg::OnBnClickedChkP310Oe)
	ON_BN_CLICKED(IDC_BTN_Set_P3_10, &CPL254311GPIODlg::OnBnClickedBtnSetP310)
	ON_BN_CLICKED(IDC_BTN_Get_P3_10, &CPL254311GPIODlg::OnBnClickedBtnGetP310)
	ON_BN_CLICKED(IDC_CHK_TX_LED0_CE, &CPL254311GPIODlg::OnBnClickedChkTxLed0Ce)
	ON_BN_CLICKED(IDC_CHK_TX_LED0_OE, &CPL254311GPIODlg::OnBnClickedChkTxLed0Oe)
	ON_BN_CLICKED(IDC_BTN_Get_TX_LED0, &CPL254311GPIODlg::OnBnClickedBtnGetTxLed0)
	ON_BN_CLICKED(IDC_BTN_Set_TX_LED0, &CPL254311GPIODlg::OnBnClickedBtnSetTxLed0)
	ON_BN_CLICKED(IDC_CHK_RX_LED0_CE, &CPL254311GPIODlg::OnBnClickedChkRxLed0Ce)
	ON_BN_CLICKED(IDC_CHK_RX_LED0_OE, &CPL254311GPIODlg::OnBnClickedChkRxLed0Oe)
	ON_BN_CLICKED(IDC_BTN_Get_RX_LED0, &CPL254311GPIODlg::OnBnClickedBtnGetRxLed0)
	ON_BN_CLICKED(IDC_BTN_Set_RX_LED0, &CPL254311GPIODlg::OnBnClickedBtnSetRxLed0)
	ON_BN_CLICKED(IDC_CHK_TX_LED1_CE, &CPL254311GPIODlg::OnBnClickedChkTxLed1Ce)
	ON_BN_CLICKED(IDC_CHK_TX_LED1_OE, &CPL254311GPIODlg::OnBnClickedChkTxLed1Oe)
	ON_BN_CLICKED(IDC_BTN_Get_TX_LED1, &CPL254311GPIODlg::OnBnClickedBtnGetTxLed1)
	ON_BN_CLICKED(IDC_BTN_Set_TX_LED1, &CPL254311GPIODlg::OnBnClickedBtnSetTxLed1)
	ON_BN_CLICKED(IDC_CHK_RX_LED1_CE, &CPL254311GPIODlg::OnBnClickedChkRxLed1Ce)
	ON_BN_CLICKED(IDC_CHK_RX_LED1_OE, &CPL254311GPIODlg::OnBnClickedChkRxLed1Oe)
	ON_BN_CLICKED(IDC_BTN_Get_RX_LED1, &CPL254311GPIODlg::OnBnClickedBtnGetRxLed1)
	ON_BN_CLICKED(IDC_BTN_Set_RX_LED1, &CPL254311GPIODlg::OnBnClickedBtnSetRxLed1)
	ON_BN_CLICKED(IDC_CHK_TX_LED2_CE, &CPL254311GPIODlg::OnBnClickedChkTxLed2Ce)
	ON_BN_CLICKED(IDC_CHK_TX_LED2_OE, &CPL254311GPIODlg::OnBnClickedChkTxLed2Oe)
	ON_BN_CLICKED(IDC_BTN_Get_TX_LED2, &CPL254311GPIODlg::OnBnClickedBtnGetTxLed2)
	ON_BN_CLICKED(IDC_BTN_Set_TX_LED2, &CPL254311GPIODlg::OnBnClickedBtnSetTxLed2)
	ON_BN_CLICKED(IDC_CHK_RX_LED2_CE, &CPL254311GPIODlg::OnBnClickedChkRxLed2Ce)
	ON_BN_CLICKED(IDC_CHK_RX_LED2_OE, &CPL254311GPIODlg::OnBnClickedChkRxLed2Oe)
	ON_BN_CLICKED(IDC_BTN_Get_RX_LED2, &CPL254311GPIODlg::OnBnClickedBtnGetRxLed2)
	ON_BN_CLICKED(IDC_BTN_Set_RX_LED2, &CPL254311GPIODlg::OnBnClickedBtnSetRxLed2)
	ON_BN_CLICKED(IDC_CHK_TX_LED3_CE, &CPL254311GPIODlg::OnBnClickedChkTxLed3Ce)
	ON_BN_CLICKED(IDC_CHK_TX_LED3_OE, &CPL254311GPIODlg::OnBnClickedChkTxLed3Oe)
	ON_BN_CLICKED(IDC_BTN_Get_TX_LED3, &CPL254311GPIODlg::OnBnClickedBtnGetTxLed3)
	ON_BN_CLICKED(IDC_BTN_Set_TX_LED3, &CPL254311GPIODlg::OnBnClickedBtnSetTxLed3)
	ON_BN_CLICKED(IDC_CHK_RX_LED3_CE, &CPL254311GPIODlg::OnBnClickedChkRxLed3Ce)
	ON_BN_CLICKED(IDC_CHK_RX_LED3_OE, &CPL254311GPIODlg::OnBnClickedChkRxLed3Oe)
	ON_BN_CLICKED(IDC_BTN_Get_RX_LED3, &CPL254311GPIODlg::OnBnClickedBtnGetRxLed3)
	ON_BN_CLICKED(IDC_BTN_Set_RX_LED3, &CPL254311GPIODlg::OnBnClickedBtnSetRxLed3)
	ON_BN_CLICKED(IDC_BTN_SETSTATUS, &CPL254311GPIODlg::OnBnClickedBtnSetstatus)
	ON_BN_CLICKED(IDC_BTN_GETSTATUS, &CPL254311GPIODlg::OnBnClickedBtnGetstatus)
END_MESSAGE_MAP()


// CPL254311GPIODlg 訊息處理常式

BOOL CPL254311GPIODlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// 將 [關於...] 功能表加入系統功能表。

	// IDM_ABOUTBOX 必須在系統命令範圍之中。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 設定此對話方塊的圖示。當應用程式的主視窗不是對話方塊時，
	// 框架會自動從事此作業
	SetIcon(m_hIcon, TRUE);			// 設定大圖示
	SetIcon(m_hIcon, FALSE);		// 設定小圖示

	m_hCOM = INVALID_HANDLE_VALUE;

	// TODO: 在此加入額外的初始設定

	CComboBox* cb = (CComboBox*)GetDlgItem(IDC_COMBO_PORT);
	cb->SetCurSel(2);
	cb = (CComboBox*)GetDlgItem(IDC_COMBO_SIZE);
	cb->SetCurSel(3);
	cb = (CComboBox*)GetDlgItem(IDC_COMBO_STOPBIT);
	cb->SetCurSel(0);
	cb = (CComboBox*)GetDlgItem(IDC_COMBO_PARITY);
	cb->SetCurSel(0);
	cb = (CComboBox*)GetDlgItem(IDC_COMBO_BAUDRATE);
	cb->SetCurSel(17);		// 115200 bps

	return TRUE;  // 傳回 TRUE，除非您對控制項設定焦點
}

void CPL254311GPIODlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果將最小化按鈕加入您的對話方塊，您需要下列的程式碼，
// 以便繪製圖示。對於使用文件/檢視模式的 MFC 應用程式，
// 框架會自動完成此作業。

void CPL254311GPIODlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 繪製的裝置內容

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 將圖示置中於用戶端矩形
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 描繪圖示
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// 當使用者拖曳最小化視窗時，
// 系統呼叫這個功能取得游標顯示。
HCURSOR CPL254311GPIODlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CPL254311GPIODlg::OnBnClickedChkP110Ce()
{	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	DWORD nBytes;
	int PortNumber = 10 ;
	int  Channel = 1;
	BOOL enable;
	BOOL CHK = FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_P1_10_CE.GetCheck()) {

	enable = 1;  // CE enable, GPIO:input mode
	CHK = TRUE;

	mc_P1_10_OE.EnableWindow(1);
	mc_P1_10_OE.SetCheck(0);
	mc_P1_10_Get.EnableWindow(1);

	}
else {

	enable = 0;  // CE disable, 回復原狀

	mc_P1_10_OE.EnableWindow(0);
	mc_P1_10_OE.SetCheck(0);
	mc_P1_10_Get.EnableWindow(0);
	}

	mc_P1_10_Set.EnableWindow(0);
	mc_P1_10_edit.EnableWindow(0);

	//if (CHK)  PL2543_GPIO_CE_Config(m_hCOM, 0x000A, 0x0001, enable); 

	if ((errCode = PL2543_11GPIO_CE_Config(m_hCOM, 0x000A, 0x0001, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_CE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_CE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}

void CPL254311GPIODlg::AddResponseString(CString& str)
{
	CListBox* lb = (CListBox*)GetDlgItem(IDC_LIST_COMMAND_RESPONSE);
	int nIndex = lb->AddString(str);
	if (nIndex != LB_ERR || nIndex != LB_ERRSPACE)
		lb->SetCurSel(nIndex);
}

void CPL254311GPIODlg::OnBnClickedChkP110Oe()
{// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	DWORD nBytes;
	int PortNumber =10 ;
	int  Channel = 1;
	BOOL enable;
	BOOL CHK= 0;
	int errCode;
	char str[MAX_PATH];

	if (mc_P1_10_OE.GetCheck()) {

		enable= 1;  // OE enable, GPIO:output mode
		CHK = 1;

		mc_P1_10_Get.EnableWindow(0);
		mc_P1_10_Set.EnableWindow(1);
		mc_P1_10_edit.EnableWindow(1);
	}
	else {
		enable = 0;  // OE disable,  GPIO:input mode

		mc_P1_10_Get.EnableWindow(1);
		mc_P1_10_Set.EnableWindow(0);
		mc_P1_10_edit.EnableWindow(0);
	}

	//if (CHK) PL2543_GPIO_OE_Config(m_hCOM, 0x000A, 0x0001, enable);

	if ((errCode = PL2543_11GPIO_OE_Config(m_hCOM, 0x000A, 0x0001, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_OE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_OE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedButtonClear()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	CListBox* output = (CListBox*)GetDlgItem(IDC_LIST_COMMAND_RESPONSE);
	output->ResetContent();
}


void CPL254311GPIODlg::OnBnClickedChkP210Ce()
{	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	DWORD nBytes;
	int PortNumber = 10 ;
	int  Channel = 2 ;
	BOOL enable;
	BOOL CHK=0;
	int errCode;
	char str[MAX_PATH];

	if (mc_P2_10_CE.GetCheck()) {

		enable = 1;  // CE enable, GPIO:input mode
		CHK = 1;

		mc_P2_10_OE.EnableWindow(1);
		mc_P2_10_OE.SetCheck(0);
		mc_P2_10_Get.EnableWindow(1);
	
	}
	else {

		enable = 0;  // CE disable, 回復原狀

		mc_P2_10_OE.EnableWindow(0);
		mc_P2_10_OE.SetCheck(0);
		mc_P2_10_Get.EnableWindow(0);
	
	}

	mc_P2_10_Set.EnableWindow(0);
	mc_P2_10_edit.EnableWindow(0);

	//if (CHK)  PL2543_GPIO_CE_Config(m_hCOM, 0x000A, 0x0002, enable); 

	if ((errCode = PL2543_11GPIO_CE_Config(m_hCOM, 0x000A, 0x0002, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_CE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_CE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);

	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkP210Oe()
{	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	DWORD nBytes;
	int PortNumber = 10;
	int  Channel = 2;
	BOOL enable;
	BOOL CHK=0;
	int errCode;
	char str[MAX_PATH];

	if (mc_P2_10_OE.GetCheck()) {

		enable = 1;  // OE enable, GPIO:output mode
		CHK = 1;

		mc_P2_10_Get.EnableWindow(0);
		mc_P2_10_Set.EnableWindow(1);
		mc_P2_10_edit.EnableWindow(1);
	}
	else {

		enable = 0;  // OE disable, GPIO:input mode

		mc_P2_10_Get.EnableWindow(1);
		mc_P2_10_Set.EnableWindow(0);
		mc_P2_10_edit.EnableWindow(0);
	}
	
	//if (CHK) PL2543_GPIO_OE_Config(m_hCOM, 0x000A, 0x0002, enable); 

	if ((errCode = PL2543_11GPIO_OE_Config(m_hCOM, 0x000A, 0x0002, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_OE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_OE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedButton1()
{	// TODO: 在此加入控制項告知處理常式程式碼
	if (m_hCOM != INVALID_HANDLE_VALUE) {
		// CLR DTR/RTS
		::CloseHandle(m_hCOM);
		m_hCOM = INVALID_HANDLE_VALUE;
		strResponse = "Close COM port Successfully!";
		AddResponseString(strResponse);
	}
}


void CPL254311GPIODlg::OnBnClickedBtnOpen()
{	// TODO: 在此加入控制項告知處理常式程式碼
		
	CString comStr, tmpStr;
	CComboBox* cb = (CComboBox*)GetDlgItem(IDC_COMBO_PORT);
	int nIndex = cb->GetCurSel();
	if (nIndex != CB_ERR) {
		cb->GetLBText(nIndex, comStr);

		//		if(m_bWindows2000)
		//			m_hCOM = ::CreateFile(comStr, GENERIC_READ | GENERIC_WRITE,
		//					0, NULL, OPEN_EXISTING, 0, NULL);
		//		else
		tmpStr = "\\\\.\\" + comStr;
		m_hCOM = ::CreateFile(tmpStr, GENERIC_READ | GENERIC_WRITE,
			0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);

		strResponse = "OPEN " + comStr + " port ";
		if (m_hCOM == INVALID_HANDLE_VALUE)
			strResponse += "FAILED.";
		else
			strResponse += "Successfully!";
			AddResponseString(strResponse);
	}
}

void CPL254311GPIODlg::OnBnClickedBtnGetP110()
{	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//PL2543_GPIO_GET_Config(0x000A, 0x0001);
	
	if ((errCode = PL2543_11GPIO_GET_Config(m_hCOM, 0x000A, 0x0001, &val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_GET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}

	else {
		str_Response = PL2543_Getval_Printlog(0x000A, 0x0001, val);
		AddResponseString(str_Response);
	}
	
	UpdateData(FALSE);
}

void CPL254311GPIODlg::OnBnClickedBtnSetP110()
{	// TODO: 在此加入控制項告知處理常式程式碼
	
	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//val = (BYTE)atoi(m_edit_GPIO_B_0_Set_Value);  //文字轉int
	val = mv_P1_10_edit;

	//PL2543_GPIO_SET_Config(0x000A, 0x0001, val);
	if ((errCode = PL2543_11GPIO_SET_Config(m_hCOM, 0x000A, 0x0001, val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_SET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Setval_Printlog(0x000A, 0x0001, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}

void CPL254311GPIODlg::OnBnClickedBtnGetP210()
{	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//PL2543_GPIO_GET_Config(0x000A, 0x0002);
	
	if ((errCode = PL2543_11GPIO_GET_Config(m_hCOM, 0x000A, 0x0002, &val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_GET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}

	else {
		str_Response = PL2543_Getval_Printlog(0x000A, 0x0002, val);
		AddResponseString(str_Response);
	}

	UpdateData(FALSE);
}

void CPL254311GPIODlg::OnBnClickedBtnSetP210()
{	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	int errCode;
	char str[MAX_PATH];

	val = (BYTE)atoi(mv_P2_10_edit);  //文字轉int
	
	//PL2543_GPIO_SET_Config(0x000A, 0x002, val);
	if ((errCode = PL2543_11GPIO_SET_Config(m_hCOM, 0x000A, 0x0002, val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_SET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Setval_Printlog(0x000A, 0x0002, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}

void CPL254311GPIODlg::OnBnClickedChkP310Ce()
{	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber = 10;
	int  Channel = 3;
	BOOL enable;
	BOOL CHK=0;
	int errCode;
	char str[MAX_PATH];

	if (mc_P3_10_CE.GetCheck()) {

		enable =1;  // CE enable, GPIO:input mode
		CHK = 1;

		mc_P3_10_OE.EnableWindow(1);
		mc_P3_10_OE.SetCheck(0);
		mc_P3_10_Get.EnableWindow(1);
	
	}
	else {

		enable = 0;

		i_Data0 = 0x00;  // CE disable, 回復原狀

		mc_P3_10_OE.EnableWindow(0);
		mc_P3_10_OE.SetCheck(0);
		mc_P3_10_Get.EnableWindow(0);

	}

	mc_P3_10_Set.EnableWindow(0);
	mc_P3_10_edit.EnableWindow(0);

	//if (CHK)  PL2543_GPIO_CE_Config(m_hCOM, 0x000A, 0x0003, enable); 

	if ((errCode = PL2543_11GPIO_CE_Config(m_hCOM, 0x000A, 0x0003, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_CE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}

	str_Response = PL2543_CE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);

	UpdateData(FALSE);
}

void CPL254311GPIODlg::OnBnClickedChkP310Oe()
{	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber = 10 ;
	int  Channel = 3;
	BOOL enable;
	BOOL CHK=FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_P3_10_OE.GetCheck()) {

		enable = 1;  // OE enable, GPIO:output mode
		CHK = 1;

		mc_P3_10_Get.EnableWindow(0);
		mc_P3_10_Set.EnableWindow(1);
		mc_P3_10_edit.EnableWindow(1);
	}
	else {
		enable = 0;  // OE disable,  GPIO:input mode

		mc_P3_10_Get.EnableWindow(1);
		mc_P3_10_Set.EnableWindow(0);
		mc_P3_10_edit.EnableWindow(0);
	}

	//if (CHK)  PL2543_GPIO_OE_Config(m_hCOM, 0x000A, 0x0003, enable); 

	if ((errCode = PL2543_11GPIO_OE_Config(m_hCOM, 0x000A, 0x0003, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_OE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_OE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnSetP310()
{	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();	
	int errCode;
	char str[MAX_PATH];

	//val = (BYTE)atoi(m_edit_GPIO_B_0_Set_Value);  //文字轉int
	val = mv_P3_10_edit;

	//PL2543_GPIO_SET_Config(0x000A, 0x0003, val);
	if ((errCode = PL2543_11GPIO_SET_Config(m_hCOM, 0x000A, 0x0003, val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_SET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Setval_Printlog(0x000A, 0x0003, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnGetP310()
{	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//PL2543_GPIO_GET_Config(0x000A, 0x0003);
	
	if ((errCode = PL2543_11GPIO_GET_Config(m_hCOM, 0x000A, 0x0003, &val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_GET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Getval_Printlog(0x000A, 0x0003, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkTxLed0Ce()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	DWORD nBytes;
	int PortNumber = 8;
	int  Channel = 0;
	BOOL enable;
	BOOL CHK = FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_TX_LED0_CE.GetCheck()) {

		enable = 1;
		CHK = TRUE;

		mc_TX_LED0_OE.EnableWindow(1);
		mc_TX_LED0_OE.SetCheck(0);
		mc_TX_LED0_Get.EnableWindow(1);

	}
	else {

		enable = 0;

		mc_TX_LED0_OE.EnableWindow(0);
		mc_TX_LED0_OE.SetCheck(0);
		mc_TX_LED0_Get.EnableWindow(0);

	}

	mc_TX_LED0_Set.EnableWindow(0);
	mc_TX_LED0_edit.EnableWindow(0);

	//if (CHK)PL2543_GPIO_CE_Config(m_hCOM, 0x0008, 0x0000, enable);

	if ((errCode = PL2543_11GPIO_CE_Config(m_hCOM, 0x0008, 0x0000, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_CE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_CE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}

CString CPL254311GPIODlg::PL2543_CE_Printlog(int errorcode, BOOL enable, int PortNumber, int Channel)
{
	if (errorcode == 0) {
		if (enable) str_Response.Format("PL2543_P%d [ %d ] GPIO Control enable.", Channel, PortNumber);
		else	str_Response.Format("PL2543_P%d [ %d ] GPIO Control disable.", Channel, PortNumber);
	}
	else {
		str_Response.Format("PL2543_P%d [ %d ] GPIO Control Enable , FAILED!", Channel, PortNumber);
	}
return str_Response;
}


void CPL254311GPIODlg::OnBnClickedChkTxLed0Oe()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber = 8;
	int  Channel = 0;
	BOOL enable;
	BOOL CHK= FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_TX_LED0_OE.GetCheck()) {

		enable = 1;  // OE enable, GPIO:output mode
		CHK = TRUE;

		mc_TX_LED0_Get.EnableWindow(0);
		mc_TX_LED0_Set.EnableWindow(1);
		mc_TX_LED0_edit.EnableWindow(1);
	}
	else {

		enable = 0;  // OE disable,  GPIO:input mode

		mc_TX_LED0_Get.EnableWindow(1);
		mc_TX_LED0_Set.EnableWindow(0);
		mc_TX_LED0_edit.EnableWindow(0);
	}

	//if (CHK) PL2543_GPIO_OE_Config(m_hCOM, 0x0008, 0x0000, enable); 

	if ((errCode = PL2543_11GPIO_OE_Config(m_hCOM, 0x0008, 0x0000, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_OE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_OE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}

CString CPL254311GPIODlg::PL2543_OE_Printlog(int errorcode, BOOL enable, int PortNumber, int Channel)
{
	if (errorcode == 0) {
		if (enable) str_Response.Format("PL2543_P%d [ %d ] GPIO Output enable.", Channel, PortNumber);
		else	str_Response.Format("PL2543_P%d [ %d ] GPIO Output disable.", Channel, PortNumber);
	}
	else {
		str_Response.Format("PL2543_P%d [ %d ] GPIO Output Enable , FAILED!", Channel, PortNumber);
	}
	return str_Response;
}


void CPL254311GPIODlg::OnBnClickedBtnGetTxLed0()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	int errCode;
	char str[MAX_PATH];
 	//PL2543_GPIO_GET_Config(0x0008,0x0000);

	if ((errCode = PL2543_11GPIO_GET_Config(m_hCOM, 0x0008, 0x0000, &val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_GET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Getval_Printlog(0x0008, 0x0000, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}

CString CPL254311GPIODlg::PL2543_Getval_Printlog(int PortNumber, int Channel, BYTE val)
{
	str_Response.Format("P%d [ %d ] Get val: %d ", Channel, PortNumber, val);

	return str_Response;
}

void CPL254311GPIODlg::OnBnClickedBtnSetTxLed0()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	
	int errCode;
	char str[MAX_PATH];
	
	val = (BYTE)atoi(mv_TX_LED0_edit);  //文字轉int
	/*val = mv_P1_10_edit;
	str_Response.Format("val:0x%04d ", val);
	AddResponseString(str_Response);*/

	//PL2543_GPIO_SET_Config(0x0008, 0x0000,val);

	if ((errCode = PL2543_11GPIO_SET_Config(m_hCOM, 0x0008, 0x0000, val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_SET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Setval_Printlog(0x0008, 0x0000, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}

CString CPL254311GPIODlg::PL2543_Setval_Printlog(int PortNumber, int Channel, BYTE val)
{
	str_Response.Format("P%d [ %d ] Set val: %d ", Channel, PortNumber, val);
	return str_Response;
}


void CPL254311GPIODlg::OnBnClickedChkRxLed0Ce()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber = 9 ;
	int  Channel = 0;
	BOOL enable;
	BOOL CHK=FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_RX_LED0_CE.GetCheck()) {

		enable = 1;  
		CHK = TRUE;

		mc_RX_LED0_OE.EnableWindow(1);
		mc_RX_LED0_OE.SetCheck(0);
		mc_RX_LED0_Get.EnableWindow(1);

	}
	else {

		enable= 0; 

		mc_RX_LED0_OE.EnableWindow(0);
		mc_RX_LED0_OE.SetCheck(0);
		mc_RX_LED0_Get.EnableWindow(0);

	}

	mc_RX_LED0_Set.EnableWindow(0);
	mc_RX_LED0_edit.EnableWindow(0);

	//if (CHK)PL2543_GPIO_CE_Config(m_hCOM, 0x0009, 0x0000, enable);

	if ((errCode = PL2543_11GPIO_CE_Config(m_hCOM, 0x0009, 0x0000, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_CE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_CE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);

	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkRxLed0Oe()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	DWORD nBytes;
	int PortNumber = 9;
	int  Channel = 0;
	BOOL enable;
	BOOL CHK = FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_RX_LED0_OE.GetCheck()) {

		enable = 1;  // OE enable, GPIO:output mode
		CHK = TRUE;

		mc_RX_LED0_Get.EnableWindow(0);
		mc_RX_LED0_Set.EnableWindow(1);
		mc_RX_LED0_edit.EnableWindow(1);
	}
	else {

		enable = 0;  // OE disable,  GPIO:input mode
		
		mc_RX_LED0_Get.EnableWindow(1);
		mc_RX_LED0_Set.EnableWindow(0);
		mc_RX_LED0_edit.EnableWindow(0);
	}

	//if (CHK) PL2543_GPIO_OE_Config(m_hCOM, 0x0009, 0x0000, enable); 

	if ((errCode = PL2543_11GPIO_OE_Config(m_hCOM, 0x0009, 0x0000, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_OE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_OE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnGetRxLed0()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	int errCode;
	char str[MAX_PATH];
	
	//PL2543_GPIO_GET_Config(0x0009,0x0000);
	if ((errCode = PL2543_11GPIO_GET_Config(m_hCOM, 0x0009, 0x0000, &val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_GET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Getval_Printlog(0x0009, 0x0000, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnSetRxLed0()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	int errCode;
	char str[MAX_PATH];


	val = (BYTE)atoi(mv_RX_LED0_edit);  //文字轉int
	/*val = mv_P1_10_edit;
	str_Response.Format("val: 0x%04d ", val);
	AddResponseString(str_Response);*/

	//PL2543_GPIO_SET_Config(0x0009, 0x0000, val);

	if ((errCode = PL2543_11GPIO_SET_Config(m_hCOM, 0x0009, 0x0000, val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_SET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}

	else {
		str_Response = PL2543_Setval_Printlog(0x0009, 0x0000, val);
		AddResponseString(str_Response);
	}

	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkTxLed1Ce()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber = 8 ;
	int  Channel = 1 ;
	BOOL enable;
	BOOL CHK=FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_TX_LED1_CE.GetCheck()) {

		enable = 1; 
		CHK = TRUE;

		mc_TX_LED1_OE.EnableWindow(1);
		mc_TX_LED1_OE.SetCheck(0);
		mc_TX_LED1_Get.EnableWindow(1);
		
	}
	else {

		enable = 0; 

		mc_TX_LED1_OE.EnableWindow(0);
		mc_TX_LED1_OE.SetCheck(0);
		mc_TX_LED1_Get.EnableWindow(0);
	
	}

	mc_TX_LED1_Set.EnableWindow(0);
	mc_TX_LED1_edit.EnableWindow(0);

	//if (CHK) PL2543_GPIO_CE_Config(m_hCOM, 0x0008, 0x0001, enable);

	if ((errCode = PL2543_11GPIO_CE_Config(m_hCOM, 0x0008, 0x0001, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_CE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_CE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);

	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkTxLed1Oe()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	DWORD nBytes;
	int PortNumber = 8;
	int  Channel = 1;
	BOOL enable;
	BOOL CHK=FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_TX_LED1_OE.GetCheck()) {

		enable = 1;  // OE enable, GPIO:output mode
		CHK = TRUE;

		mc_TX_LED1_Get.EnableWindow(0);
		mc_TX_LED1_Set.EnableWindow(1);
		mc_TX_LED1_edit.EnableWindow(1);
	}
	else {

		enable = 0;  // OE disable,  GPIO:input mode

		mc_TX_LED1_Get.EnableWindow(1);
		mc_TX_LED1_Set.EnableWindow(0);
		mc_TX_LED1_edit.EnableWindow(0);
	}

	//if (CHK) { PL2543_GPIO_OE_Config(m_hCOM, 0x0008, 0x0001, enable); }

	if ((errCode = PL2543_11GPIO_OE_Config(m_hCOM, 0x0008, 0x0001, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_OE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_OE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnGetTxLed1()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//PL2543_GPIO_GET_Config(0x0008, 0x0001);
	
	if ((errCode = PL2543_11GPIO_GET_Config(m_hCOM, 0x0008, 0x0001, &val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_GET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Getval_Printlog(0x0008, 0x0001, val);
		AddResponseString(str_Response);
	}

	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnSetTxLed1()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//val = (BYTE)atoi(mv_TX_LED1_edit);  //文字轉int
	val = mv_TX_LED1_edit;

	//PL2543_GPIO_SET_Config(0x0008,0x0001,val);
	if ((errCode = PL2543_11GPIO_SET_Config(m_hCOM, 0x0008, 0x0001, val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_SET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}

	else {
		str_Response = PL2543_Setval_Printlog(0x0008, 0x0001, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkRxLed1Ce()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	DWORD nBytes;
	int PortNumber = 9 ;
	int  Channel = 1 ;
	BOOL  enable;
	BOOL CHK=FALSE;
	int errCode;
	char str[MAX_PATH];


	if (mc_RX_LED1_CE.GetCheck()) {

		enable = 1;  // CE enable, GPIO:input mode
		CHK = TRUE;

		mc_RX_LED1_OE.EnableWindow(1);
		mc_RX_LED1_OE.SetCheck(0);
		mc_RX_LED1_Get.EnableWindow(1);
	
	}
	else {

		enable= 0;  // CE disable, 回復原狀
		
		mc_RX_LED1_OE.EnableWindow(0);
		mc_RX_LED1_OE.SetCheck(0);
		mc_RX_LED1_Get.EnableWindow(0);

	}

	mc_RX_LED1_Set.EnableWindow(0);
	mc_RX_LED1_edit.EnableWindow(0);

	//if (CHK) PL2543_GPIO_CE_Config(m_hCOM, 0x0009, 0x0001, enable);

	if ((errCode = PL2543_11GPIO_CE_Config(m_hCOM, 0x0009, 0x0001, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_CE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_CE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);

	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkRxLed1Oe()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	DWORD nBytes;
	int PortNumber = 9;
	int  Channel = 1;
	BOOL enable;
	BOOL CHK = FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_RX_LED1_OE.GetCheck()) {

		enable = 1;  // OE enable, GPIO:output mode
		CHK = 1;

		mc_RX_LED1_Get.EnableWindow(0);
		mc_RX_LED1_Set.EnableWindow(1);
		mc_RX_LED1_edit.EnableWindow(1);
	}
	else {

		enable = 0;  // OE disable,  GPIO:input mode

		mc_RX_LED1_Get.EnableWindow(1);
		mc_RX_LED1_Set.EnableWindow(0);
		mc_RX_LED1_edit.EnableWindow(0);
	}

	//if (CHK) { PL2543_GPIO_OE_Config(m_hCOM, 0x0009, 0x0001, enable); }

	if ((errCode = PL2543_11GPIO_OE_Config(m_hCOM, 0x0009, 0x0001, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_OE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_OE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnGetRxLed1()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	
	int errCode;
	char str[MAX_PATH];
	//PL2543_GPIO_GET_Config(0x0009, 0x0001);
	
	if ((errCode = PL2543_11GPIO_GET_Config(m_hCOM, 0x0009, 0x0001, &val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_GET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Getval_Printlog(0x0009, 0x0001, val);
		AddResponseString(str_Response);
	}

	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnSetRxLed1()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//val = (BYTE)atoi(mv_TX_LED0_edit);  //文字轉int
	val = mv_RX_LED1_edit;

	//PL2543_GPIO_SET_Config(0x0009,0x0001,val);

	if ((errCode = PL2543_11GPIO_SET_Config(m_hCOM, 0x0009, 0x0001, val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_SET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}

	else {
		str_Response = PL2543_Setval_Printlog(0x0009, 0x0001, val);
		AddResponseString(str_Response);
	}

	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkTxLed2Ce()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber = 8;
	int  Channel = 2;
	BOOL enable;
	BOOL CHK = FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_TX_LED2_CE.GetCheck()) {

		enable = 1;  // CE enable, GPIO:input mode
		CHK = TRUE;

		mc_TX_LED2_OE.EnableWindow(1);
		mc_TX_LED2_OE.SetCheck(0);
		mc_TX_LED2_Get.EnableWindow(1);
	
	}
	else {

		enable = 0;  // CE disable, 回復原狀

		mc_TX_LED2_OE.EnableWindow(0);
		mc_TX_LED2_OE.SetCheck(0);
		mc_TX_LED2_Get.EnableWindow(0);
	
	}

	mc_TX_LED2_Set.EnableWindow(0);
	mc_TX_LED2_edit.EnableWindow(0);

	//if (CHK) PL2543_GPIO_CE_Config(m_hCOM, 0x0008, 0x0002, enable);

	if ((errCode = PL2543_11GPIO_CE_Config(m_hCOM, 0x0008, 0x0002, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_CE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_CE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);

	UpdateData(FALSE);
}



void CPL254311GPIODlg::OnBnClickedChkTxLed2Oe()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber = 8;
	int  Channel = 2;
	BOOL enable;
	BOOL CHK=FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_TX_LED2_OE.GetCheck()) {

		enable = 1;  // OE enable, GPIO:output mode
		CHK = 1;

		mc_TX_LED2_Get.EnableWindow(0);
		mc_TX_LED2_Set.EnableWindow(1);
		mc_TX_LED2_edit.EnableWindow(1);
	}
	else {

		enable = 0;  // OE disable,  GPIO:input mode

		mc_TX_LED2_Get.EnableWindow(1);
		mc_TX_LED2_Set.EnableWindow(0);
		mc_TX_LED2_edit.EnableWindow(0);
	}

	//if (CHK)  PL2543_GPIO_OE_Config(m_hCOM, 0x0008, 0x0002, enable); 

	if ((errCode = PL2543_11GPIO_OE_Config(m_hCOM, 0x0008, 0x0002, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_OE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_OE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnGetTxLed2()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	int errCode;
	char str[MAX_PATH];
	//PL2543_GPIO_GET_Config(0x0008,0x0002);
	
	if ((errCode = PL2543_11GPIO_GET_Config(m_hCOM, 0x0008, 0x0002, &val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_GET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}

	else {
		str_Response = PL2543_Getval_Printlog(0x0008, 0x0002, val);
		AddResponseString(str_Response);
	}
	
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnSetTxLed2()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();

	val = (BYTE)atoi(mv_TX_LED2_edit);  //文字轉int
	//val = mv_TX_LED2_edit;
	int errCode;
	char str[MAX_PATH];

	//PL2543_GPIO_SET_Config(0x0008,0x0002,val);
	if ((errCode = PL2543_11GPIO_SET_Config(m_hCOM, 0x0008, 0x0002, val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_SET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Setval_Printlog(0x0008, 0x0002, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkRxLed2Ce()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber = 9 ;
	int  Channel = 2;
	BOOL enable;
	BOOL CHK = FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_RX_LED2_CE.GetCheck()) {

		enable= 1;  // CE enable, GPIO:input mode
		CHK = TRUE;

		mc_RX_LED2_OE.EnableWindow(1);
		mc_RX_LED2_OE.SetCheck(0);
		mc_RX_LED2_Get.EnableWindow(1);

	}
	else {

		enable = 0;  // CE disable, 回復原狀

		mc_RX_LED2_OE.EnableWindow(0);
		mc_RX_LED2_OE.SetCheck(0);
		mc_RX_LED2_Get.EnableWindow(0);

	}

	mc_RX_LED2_Set.EnableWindow(0);
	mc_RX_LED2_edit.EnableWindow(0);

	//if (CHK) PL2543_GPIO_CE_Config(m_hCOM, 0x0009, 0x0002, enable);
	
	if ((errCode = PL2543_11GPIO_CE_Config(m_hCOM, 0x0009, 0x0002, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_CE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_CE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkRxLed2Oe()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber = 9;
	int  Channel = 2;
	BOOL enable;
	BOOL CHK=FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_RX_LED2_OE.GetCheck()) {

		enable = 1;  // OE enable, GPIO:output mode
		CHK = 1;

		mc_RX_LED2_Get.EnableWindow(0);
		mc_RX_LED2_Set.EnableWindow(1);
		mc_RX_LED2_edit.EnableWindow(1);
	}
	else {
		enable = 0;  // OE disable,  GPIO:input mode

		mc_RX_LED2_Get.EnableWindow(1);
		mc_RX_LED2_Set.EnableWindow(0);
		mc_RX_LED2_edit.EnableWindow(0);
	}

	//if (CHK)  PL2543_GPIO_OE_Config(m_hCOM, 0x0009, 0x0002, enable); 

	if ((errCode = PL2543_11GPIO_OE_Config(m_hCOM, 0x0009, 0x0002, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_OE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_OE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnGetRxLed2()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//PL2543_GPIO_GET_Config(0x0009,0x0002);
	if ((errCode = PL2543_11GPIO_GET_Config(m_hCOM, 0x0009, 0x0002, &val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_GET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Getval_Printlog(0x0009, 0x0002, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnSetRxLed2()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//val = (BYTE)atoi(mv_TX_LED0_edit);  //文字轉int
	val = mv_RX_LED2_edit;

	//PL2543_GPIO_SET_Config(0x0009,0x0002,val);
	if ((errCode = PL2543_11GPIO_SET_Config(m_hCOM, 0x0009, 0x0002, val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_SET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Setval_Printlog(0x0009, 0x0002, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkTxLed3Ce()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber = 8;
	int  Channel = 3;
	BOOL enable;
	BOOL CHK=FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_TX_LED3_CE.GetCheck()) {

		enable = 1;  // CE enable, GPIO:input mode
		CHK = TRUE;

		mc_TX_LED3_OE.EnableWindow(1);
		mc_TX_LED3_OE.SetCheck(0);
		mc_TX_LED3_Get.EnableWindow(1);

	}
	else {

		enable = 0;  // CE disable, 回復原狀

		mc_TX_LED3_OE.EnableWindow(0);
		mc_TX_LED3_OE.SetCheck(0);
		mc_TX_LED3_Get.EnableWindow(0);

	}

	mc_TX_LED3_Set.EnableWindow(0);
	mc_TX_LED3_edit.EnableWindow(0);

	//if (CHK) PL2543_GPIO_CE_Config(m_hCOM, 0x0008, 0x0003, enable);
	
	if ((errCode = PL2543_11GPIO_CE_Config(m_hCOM, 0x0008, 0x0003, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_CE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_CE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkTxLed3Oe()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber =8 ;
	int  Channel = 3;
	BOOL enable;
	BOOL CHK = FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_TX_LED3_OE.GetCheck()) {

		enable= 1;  // OE enable, GPIO:output mode
		CHK = 1;

		mc_TX_LED3_Get.EnableWindow(0);
		mc_TX_LED3_Set.EnableWindow(1);
		mc_TX_LED3_edit.EnableWindow(1);
	}
	else {
		enable= 0;  // OE disable,  GPIO:input mode

		mc_TX_LED3_Get.EnableWindow(1);
		mc_TX_LED3_Set.EnableWindow(0);
		mc_TX_LED3_edit.EnableWindow(0);
	}

	//if (CHK) PL2543_GPIO_OE_Config(m_hCOM, 0x0008, 0x0003, enable); 

	if ((errCode = PL2543_11GPIO_OE_Config(m_hCOM, 0x0008, 0x0003, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_OE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_OE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnGetTxLed3()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//PL2543_GPIO_GET_Config(0x0008, 0x0003);
	
	if ((errCode = PL2543_11GPIO_GET_Config(m_hCOM, 0x0008, 0x0003, &val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_GET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Getval_Printlog(0x0008, 0x0003, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnSetTxLed3()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//val = (BYTE)atoi(mv_TX_LED0_edit);  //文字轉int
	val = mv_TX_LED3_edit;

	//PL2543_GPIO_SET_Config(0x0008, 0x0003, val);
	if ((errCode = PL2543_11GPIO_SET_Config(m_hCOM, 0x0008, 0x0003, val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_SET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Setval_Printlog(0x0008, 0x0003, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkRxLed3Ce()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber = 9;
	int  Channel = 3;
	BOOL enable;
	BOOL CHK = FALSE;
	int errCode;
	char str[MAX_PATH];

	i_wValue = 0x0009;		//Port Number
	i_wIndex = 0x0003;		//channel select

	if (mc_RX_LED3_CE.GetCheck()) {

		enable = 1;  // CE enable, GPIO:input mode
		CHK = TRUE;

		mc_RX_LED3_OE.EnableWindow(1);
		mc_RX_LED3_OE.SetCheck(0);
		mc_RX_LED3_Get.EnableWindow(1);

	}
	else {

		enable = 0;

		i_Data0 = 0x00;  // CE disable, 回復原狀

		mc_RX_LED3_OE.EnableWindow(0);
		mc_RX_LED3_OE.SetCheck(0);
		mc_RX_LED3_Get.EnableWindow(0);

	}

	mc_RX_LED3_Set.EnableWindow(0);
	mc_RX_LED3_edit.EnableWindow(0);

	//if (CHK) PL2543_GPIO_CE_Config(m_hCOM, 0x0009, 0x0003, enable); 

	if ((errCode = PL2543_11GPIO_CE_Config(m_hCOM, 0x0009, 0x0003, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_CE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_CE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedChkRxLed3Oe()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	DWORD nBytes;
	int PortNumber =9 ;
	int  Channel = 3;
	BOOL enable;
	BOOL CHK = FALSE;
	int errCode;
	char str[MAX_PATH];

	if (mc_RX_LED3_OE.GetCheck()) {

		enable= 1;  // OE enable, GPIO:output mode
		CHK = 1;

		mc_RX_LED3_Get.EnableWindow(0);
		mc_RX_LED3_Set.EnableWindow(1);
		mc_RX_LED3_edit.EnableWindow(1);
	}
	else {
		enable = 0;  // OE disable,  GPIO:input mode

		mc_RX_LED3_Get.EnableWindow(1);
		mc_RX_LED3_Set.EnableWindow(0);
		mc_RX_LED3_edit.EnableWindow(0);
	}

	//if (CHK) PL2543_GPIO_OE_Config(m_hCOM, 0x0009, 0x0003, enable); 

	if ((errCode = PL2543_11GPIO_OE_Config(m_hCOM, 0x0009, 0x0003, enable)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_OE_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	str_Response = PL2543_OE_Printlog(errCode, enable, PortNumber, Channel);
	AddResponseString(str_Response);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnGetRxLed3()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	UpdateData();
	int errCode;
	char str[MAX_PATH];

	//PL2543_GPIO_GET_Config(0x0009, 0x0003);
	
	if ((errCode = PL2543_11GPIO_GET_Config(m_hCOM, 0x0009, 0x0003, &val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_GET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
	else {
		str_Response = PL2543_Getval_Printlog(0x0009, 0x0003, val);
		AddResponseString(str_Response);
	}
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnSetRxLed3()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	int errCode;
	char str[MAX_PATH];

	val = (BYTE)atoi(mv_RX_LED3_edit);  //文字轉int
	//val = mv_P1_10_edit;

	//PL2543_GPIO_SET_Config(0x0009,0x0003,val);
		if ((errCode = PL2543_11GPIO_SET_Config(m_hCOM, 0x0009, 0x0003, val)) != STATUS_SUCCESS) {
		wsprintf(str, "PL2543_GPIO_SET_Config Failed! - %d", errCode);
		MessageBox(str, "ERROR", MB_OK | MB_ICONSTOP);
		return;
	}
		else {
			str_Response = PL2543_Setval_Printlog(0x0009, 0x0003, val);
			AddResponseString(str_Response);
		}
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnSetstatus()
{
	// TODO: 在此加入控制項告知處理常式程式碼

	UpdateData();
	CString str;
	BOOL bSuccess;

	if (m_hCOM == INVALID_HANDLE_VALUE) {
		str = "Choose a COM port to set status.";
		AddResponseString(str);
		return;
	}

	bSuccess = ::GetCommState(m_hCOM, &m_DCB);
	if (!bSuccess) {
		str = "SET port status FAILED because cannot get status.";
		AddResponseString(str);
		return;
	}

	CComboBox* cb = (CComboBox*)GetDlgItem(IDC_COMBO_BAUDRATE);
	int nIndex = cb->GetCurSel();
	cb->GetLBText(nIndex, str);
	m_DCB.BaudRate = atol(str);

	cb = (CComboBox*)GetDlgItem(IDC_COMBO_SIZE);
	nIndex = cb->GetCurSel();
	cb->GetLBText(nIndex, str);
	m_DCB.ByteSize = atoi(str);

	cb = (CComboBox*)GetDlgItem(IDC_COMBO_STOPBIT);
	m_DCB.StopBits = cb->GetCurSel();

	cb = (CComboBox*)GetDlgItem(IDC_COMBO_PARITY);
	m_DCB.Parity = cb->GetCurSel();

	if ((m_DCB.ByteSize == 6 || m_DCB.ByteSize == 7 || m_DCB.ByteSize == 8) && (m_DCB.StopBits == 1)) {
		str = "ERROR - CANNOT set such combination.";
		AddResponseString(str);
		return;
	}

	if ((m_DCB.ByteSize == 5) && (m_DCB.StopBits == 2)) {
		str = "ERROR - CANNOT set such combination.";
		AddResponseString(str);
		return;
	}

	if (m_DCB.ByteSize == 5)
		m_DCB.StopBits++;

	bSuccess = ::SetCommState(m_hCOM, &m_DCB);
	if (!bSuccess) {
		str = "SET port status FAILED.";
		AddResponseString(str);
		return;
	}
	str = "SET port status Successfully!";
	AddResponseString(str);
	UpdateData(FALSE);
}


void CPL254311GPIODlg::OnBnClickedBtnGetstatus()
{
	// TODO: 在此加入控制項告知處理常式程式碼
	CString str;
	const char* parityStr[] = { "None","Odd","Even","Mark","Space" };
	const char* stopBitsStr[] = { "1", "1.5", "2" };

	if (m_hCOM == INVALID_HANDLE_VALUE) {
		str = "Choose a COM port to get status.";
		AddResponseString(str);
		return;
	}

	BOOL bSuccess = ::GetCommState(m_hCOM, &m_DCB);
	if (!bSuccess) {
		str = "GET port status FAILED.";
		AddResponseString(str);
		return;
	}

	if (m_DCB.ByteSize == 5 && m_DCB.StopBits > 0)
		m_DCB.StopBits--;

	str.Format("BaudRate: %ld", m_DCB.BaudRate);
	AddResponseString(str);

	str.Format("Parity: %s", parityStr[m_DCB.Parity]);
	AddResponseString(str);

	str.Format("ByteSize: %d", m_DCB.ByteSize);
	AddResponseString(str);

	str.Format("StopBits: %s", stopBitsStr[m_DCB.StopBits]);
	AddResponseString(str);

	str = "------------------------------------------";
	AddResponseString(str);

}



/*BOOL CPL254311GPIODlg::PL2543_GPIO_CE_Config(HANDLE m_hCOM, BYTE PortNumber, BYTE Channel, BOOL enable)
{
	DWORD nBytes;
	BOOL bSuccess;
	USHORT buffer[5];

	if (m_hCOM == INVALID_HANDLE_VALUE) {
		return FALSE;
	}

	ZeroMemory(buffer, sizeof(buffer));

	buffer[0] = (USHORT)PortNumber;
	buffer[1] = (USHORT)Channel;

	if (enable) buffer[2] = (USHORT)0xB1;  // CE enable, GPIO:input mode
	else buffer[2] = (USHORT)0x00;  // CE disable,  // 回復原狀態

	buffer[3] = (USHORT)0x00;
	buffer[4] = (USHORT)0x00;

	str_Response.Format("PortNumber: 0x%04X, ChannelSelect: 0x%04X, Byte 0: 0x%04X, Byte 1[1]: 0x%04X, Byte 2[2]: 0x%04X", buffer[0], buffer[1], buffer[2], buffer[3], buffer[4]);
	//AddResponseString(str_Response);

	bSuccess = DeviceIoControl(m_hCOM, PL256X_Vendor_GPIO_SET,
		buffer, sizeof(buffer), NULL, 0, &nBytes, NULL);

	if (bSuccess)
		str_Response.Format("PL2543_Port_%d [ %d ]_GPIO_Control enable , Successfully!", PortNumber, Channel);
	else
		str_Response.Format("PL2543_Port_%d [ %d ]_GPIO_control enable , FAILED!", PortNumber, Channel);
		AddResponseString(str_Response);

	return bSuccess;
}*/

/*BOOL CPL254311GPIODlg::PL2543_GPIO_OE_Config(HANDLE m_hCOM, BYTE PortNumber, BYTE Channel, BOOL enable)
{
	DWORD nBytes;
	BOOL bSuccess;
	USHORT buffer[5];

	if (m_hCOM == INVALID_HANDLE_VALUE) {
		return FALSE;
	}

	ZeroMemory(buffer, sizeof(buffer));

	buffer[0] = (USHORT)PortNumber;
	buffer[1] = (USHORT)Channel;

	if (enable) buffer[2] = (USHORT)0xB2;  // OE enable, GPIO:input mode
	else buffer[2] = (USHORT)0xB1;  // OE disable,  // 回復原狀態

	buffer[3] = (USHORT)0x00;
	buffer[4] = (USHORT)0x00;

	str_Response.Format("PortNumber: 0x%04X, ChannelSelect: 0x%04X, Byte 0: 0x%04X, Byte 1[1]: 0x%04X, Byte 2[2]: 0x%04X", buffer[0], buffer[1], buffer[2], buffer[3], buffer[4]);
	//AddResponseString(str_Response);

	bSuccess = DeviceIoControl(m_hCOM, PL256X_Vendor_GPIO_SET,
		buffer, sizeof(buffer), NULL, 0, &nBytes, NULL);

	if (bSuccess)
		str_Response.Format("PL2543_Port_%d [ %d ]_GPIO_Output enable , Successfully!", buffer[0], buffer[1]);
	else
		str_Response.Format("PL2543_Port_%d [ %d ]_GPIO_Output enable , FAILED!", buffer[0], buffer[1]);
		AddResponseString(str_Response);

	return bSuccess;
}*/

/*void CPL254311GPIODlg::PL2543_GPIO_GET_Config(BYTE PortNumber, BYTE Channel)
{
	USHORT inputBuffer[2];
	DWORD nBytes;
	BYTE output[1];

	ZeroMemory(inputBuffer, sizeof(inputBuffer));

	inputBuffer[0] = (WORD)PortNumber;
	inputBuffer[1] = (WORD)Channel;

	str_Response.Format("PortNumber: 0x%04X, ChannelSelect: 0x%04X", inputBuffer[0], inputBuffer[1]);
	//AddResponseString(str_Response);

	BOOL bSuccess = DeviceIoControl(m_hCOM, PL256X_Vendor_GPIO_Read,
		inputBuffer, sizeof(inputBuffer), output, 1, &nBytes, NULL);

	if (bSuccess) {
		str_Response.Format("PL2543_Port_%d [ %d ]_GPIO_Value : %d",PortNumber,Channel, output[0]);
		AddResponseString(str_Response);
	}
	
}*/

/*void CPL254311GPIODlg::PL2543_GPIO_SET_Config(BYTE i_wValue, BYTE i_wIndex, BYTE val)
{
	DWORD nBytes;

	ZeroMemory(buffer, sizeof(buffer));
	str_Response.Format("buffer: 0x%04p ", buffer);
	//AddResponseString(str_Response);

	buffer[0] = (USHORT)i_wValue;  // 0x000x
	buffer[1] = (USHORT)i_wIndex;
	str_Response.Format("buffer[0]: 0x%04d,buffer[1]: 0x%04d ", buffer[0], buffer[1]);
	//AddResponseString(str_Response);

	if (val == 1) {
		buffer[0] |= 0x0100;  // output high ,  // 0x010x
		str_Response.Format("buffer[0]: 0x%04X ", buffer[0]);
		//AddResponseString(str_Response);
	}
	else {
		buffer[0] &= ~0x0100;  // output low    // 0x000x
		str_Response.Format("buffer[0]: 0x%04X ", buffer[0]);
		//AddResponseString(str_Response);
	}

	str_Response.Format("PortNumber : 0x%04X , Channel : 0x%04X", buffer[0], buffer[1]);
	AddResponseString(str_Response);

	BOOL bSuccess = DeviceIoControl(m_hCOM, PL256X_Vendor_GPIO_Write,
		buffer, sizeof(buffer), NULL, 0, &nBytes, NULL);

	if (bSuccess)
		str_Response.Format("PL2543_Port_GPIO_Set : %d , Successfully!", val);
	else
		str_Response.Format("PL2543_Port_GPIO_Set : , FAILED!");
		AddResponseString(str_Response);
}*/
