package com.prolific.pl25x3gpio;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbManager;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.Toast;

import java.util.Arrays;

import tw.com.prolific.pl25x3Lib.PL25x3Lib;

public class MainActivity extends AppCompatActivity {
    private String[] m_strShowGPIO2543 = {"P0_GPIO8", "P0_GPIO9", "P1_GPIO8", "P1_GPIO9", "P1_GPIO10",
            "P2_GPIO8", "P2_GPIO9", "P2_GPIO10", "P3_GPIO8", "P3_GPIO9", "P3_GPIO10"};
    private String[] m_strShowGPIO2523 = {"P0_GPIO8", "P0_GPIO9", "P1_GPIO8", "P1_GPIO9", "P2_GPIO7_RI", "P2_GPIO9", "P3_GPIO10"};
    private int[] m_nShowGPIO2543 = {8, 9, 8, 9, 10, 8, 9, 10, 8, 9, 10};
    private int[] m_nShowGPIO2523 = {8, 9, 8, 9, 7, 9, 10};
    private String m_strGPIOValue;
    private ArrayAdapter<String> m_arrAdapter;
    private ImageView m_imgDeviceStatus;

    private static final boolean SHOW_DEBUG = true;
    PL25x3Lib m_Serial;
    String m_strTAG = "PL25x3_APLog";
    private int m_nBaudrate = 9600;
    private PL25x3Lib.DataBits m_DataBits = PL25x3Lib.DataBits.D8;
    private PL25x3Lib.Parity m_Parity = PL25x3Lib.Parity.NONE;
    private PL25x3Lib.StopBits m_StopBits = PL25x3Lib.StopBits.S1;
    private PL25x3Lib.FlowControl m_FlowControl = PL25x3Lib.FlowControl.OFF;

    private final int GPIO_MODE_DEFAULT = 0;
    private final int GPIO_MODE_INPUT = 1;
    private final int GPIO_MODE_OUTPUT = 2;
    private final int m_nNO_DEVICE_INDEX = -1;
    private int m_nGpioPinNum = 0, m_nGpioValue = -1;
    private static final String ACTION_USB_PERMISSION = "com.prolific.pl2543_multisimpletest.USB_PERMISSION";
    private static final int DEFAULT_2523_BCD = 0x4302;
    private static final int DEFAULT_2543_BCD = 0x4304;
    private IntentFilter m_intentFilter;

    private int m_nDeviceCount = 0;
    //channel select / port index(P0~P3)
    private int m_nChannelSelectValue = m_nNO_DEVICE_INDEX;
    //device index for open
    private int m_nDeviceIndexForOpen = 0;
    private boolean[] m_bIsDeviceOpen;
    private boolean m_bIsPL2543 = true;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getSupportActionBar().hide(); //隱藏標題
        getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_FULLSCREEN);
        setContentView(R.layout.activity_main);
        requestData();
        // get service
        m_Serial = new PL25x3Lib(
                (UsbManager) getSystemService(Context.USB_SERVICE), this,
                ACTION_USB_PERMISSION);
        m_intentFilter = new IntentFilter(ACTION_USB_PERMISSION);
        m_intentFilter.addAction(UsbManager.ACTION_USB_DEVICE_ATTACHED);
        m_intentFilter.addAction(UsbManager.ACTION_USB_DEVICE_DETACHED);
        if (broadCastUsbReceiver != null) {
            registerReceiver(broadCastUsbReceiver, m_intentFilter);
        }
    }

    private final BroadcastReceiver broadCastUsbReceiver = new BroadcastReceiver() {
        public void onReceive(Context context, Intent intent) {
            Log.d(m_strTAG,"BroadcastReceiver-onReceive");
            String strAction = intent.getAction();
            if (UsbManager.ACTION_USB_DEVICE_ATTACHED.equals(strAction)) {
                Log.d(m_strTAG,"ACTION_USB_DEVICE_ATTACHED");
                //refresh enumdevice
                synchronized (this) {
                    m_imgDeviceStatus.setImageResource(R.mipmap.connect_device);
                }
                Toast.makeText(MainActivity.this, "attached 2", Toast.LENGTH_SHORT).show();
                Log.d(m_strTAG,"enumerate succeeded!");
            }
            if (UsbManager.ACTION_USB_DEVICE_DETACHED.equals(strAction)) {
                Log.d(m_strTAG,"ACTION_USB_DEVICE_DETACHED");
                //Remove Device, Cleans and closes communication with the device
                synchronized (this) {
                    m_imgDeviceStatus.setImageResource(R.mipmap.disconnect_device);
                }
                Log.d(m_strTAG,"Device detached.");
            }
            if(ACTION_USB_PERMISSION.equals(strAction)){
                if (intent.getBooleanExtra(UsbManager.EXTRA_PERMISSION_GRANTED, false)) {
                    synchronized (this) {
                        if (null == m_Serial) {
                            Log.d(m_strTAG, "mSerial is null");
                            // get service
                            m_Serial = new PL25x3Lib(
                                    (UsbManager) getSystemService(Context.USB_SERVICE), MainActivity.this,
                                    ACTION_USB_PERMISSION);
                        }
                        //判斷ic要寫在這裡 m_SerialMulti.PL254XGetBcdByIndex(xxxx)
                        m_nDeviceCount = m_Serial.PL25x3_Enumerate();
                        if (m_Serial.PL25x3_GetBcdByIndex(0) == Integer.parseInt(Integer.toString(DEFAULT_2543_BCD))) {
                            m_bIsPL2543 = true;
                        } else {
                            m_bIsPL2543 = false;
                        }
                        if (0 == m_nDeviceCount) {
                            Toast.makeText(MainActivity.this, "no more devices found", Toast.LENGTH_SHORT).show();

                            m_nChannelSelectValue = m_nNO_DEVICE_INDEX;
                            m_imgDeviceStatus.setImageResource(R.mipmap.disconnect_device);
                            return;
                        } else {
                            Log.d(m_strTAG, "onResume:enumerate="+ m_nDeviceCount);
                            m_nChannelSelectValue = 0;
                            m_bIsDeviceOpen = new boolean[4];
                            Arrays.fill(m_bIsDeviceOpen, false);
                            m_imgDeviceStatus.setImageResource(R.mipmap.connect_device);
                            Toast.makeText(MainActivity.this, "attached", Toast.LENGTH_SHORT).show();
                        }
                    }
                }
            }
        }//onReceive
    };

    @Override
    protected void onDestroy() {
        Log.d(m_strTAG, "Enter onDestroy");
        if (m_Serial != null) {
            m_Serial.PL25x3_Close();
            m_Serial = null;
        }
        super.onDestroy();
        Log.d(m_strTAG, "Leave onDestroy");
    }

    @Override
    public void onResume() {
        Log.d(m_strTAG, "Enter onResume");
        super.onResume();
        //if close usb serial will null
        if (null == m_Serial) {
            Log.d(m_strTAG, "mSerial is null");
            m_Serial = new PL25x3Lib(
                    (UsbManager) getSystemService(Context.USB_SERVICE), MainActivity.this,
                    ACTION_USB_PERMISSION);
        }
        String strAction = getIntent().getAction();
        Log.d(m_strTAG, "onResume:" + strAction);
        m_nDeviceCount = m_Serial.PL25x3_Enumerate();
        if (0 == m_nDeviceCount) {
            Toast.makeText(this, "no more devices found",
                    Toast.LENGTH_SHORT).show();
            m_nChannelSelectValue = m_nNO_DEVICE_INDEX;
            m_imgDeviceStatus.setImageResource(R.mipmap.disconnect_device);
            return;
        } else {
            if (m_Serial.PL25x3_GetBcdByIndex(0) == Integer.parseInt(Integer.toString(DEFAULT_2543_BCD))) {
                m_bIsPL2543 = true;
            } else {
                m_bIsPL2543 = false;
            }
            Log.d(m_strTAG, "onResume:enumerate="+ m_nDeviceCount);
            m_nChannelSelectValue = 0;
            m_bIsDeviceOpen = new boolean[4];
            Arrays.fill(m_bIsDeviceOpen, false);
        }
        requestData();
        m_imgDeviceStatus.setImageResource(R.mipmap.connect_device);
        Toast.makeText(this, "attached", Toast.LENGTH_SHORT).show();
        Log.d(m_strTAG, "Leave onResume");
    }

    private void requestData() {
        m_imgDeviceStatus = (ImageView)findViewById(R.id.img_deviceStatus);
        ListView lstGPIO = (ListView) findViewById(R.id.lvGPIO);
        if (m_bIsPL2543) {
            m_arrAdapter = new ArrayAdapter(this, android.R.layout.simple_list_item_1, m_strShowGPIO2543);
        } else {
            m_arrAdapter = new ArrayAdapter(this, android.R.layout.simple_list_item_1, m_strShowGPIO2523);
        }
        lstGPIO.setAdapter(m_arrAdapter);
        lstGPIO.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @Override
            public void onItemClick(AdapterView<?> parent, View view, final int position_List, long id) {
                LayoutInflater inflater = LayoutInflater.from(MainActivity.this);
                final View v = inflater.inflate(R.layout.alertdialog_gpio, null);
                final Spinner spnGpio = (Spinner)v.findViewById(R.id.sp_gpio);
                final EditText edtGpio = (EditText)v.findViewById(R.id.et_gpio);
                if (m_bIsPL2543) {
                    m_nGpioPinNum = m_nShowGPIO2543[position_List];
                    m_strGPIOValue = m_strShowGPIO2543[position_List];
                } else {
                    m_nGpioPinNum = m_nShowGPIO2523[position_List];
                    m_strGPIOValue = m_strShowGPIO2523[position_List];
                }
                final AlertDialog.Builder builder = new AlertDialog.Builder(MainActivity.this)
                        .setTitle("Set " + m_strGPIOValue)
                        .setView(v)
                        .setPositiveButton("Close",null)
                        .setNegativeButton("Run", null);

                ArrayAdapter<String> adapter = new ArrayAdapter<String>(MainActivity.this,
                        android.R.layout.simple_spinner_item,getResources().getStringArray(R.array.gpio));
                adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                spnGpio.setAdapter(adapter);
                spnGpio.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                    @Override
                    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                        if(position==1){
                            edtGpio.setEnabled(false);
                            edtGpio.getText().clear();
                            edtGpio.setHint("Get "+ m_strGPIOValue);
                            builder.setPositiveButton("Get", null);
                        }
                        if(position==0){
                            edtGpio.setEnabled(true);
                            edtGpio.getText().clear();
                            edtGpio.setHint("Please input 0 or 1");
                            builder.setPositiveButton("Set", null);
                        }
                    }

                    @Override
                    public void onNothingSelected(AdapterView<?> parent) {
                    }
                });

                final AlertDialog dialog = builder.create();
                dialog.show();
                dialog.getButton(AlertDialog.BUTTON_NEGATIVE).setOnClickListener(new View.OnClickListener() {

                    @Override
                    public void onClick(View view) {
                        if(spnGpio.getSelectedItemPosition() == 0) { //send value
                            if (inputValueCheck(spnGpio, edtGpio)) {
                                int nRes = onSetGpio();
                                if (nRes < 0) {
                                    ShowDialog("Error", "Set " + m_strGPIOValue + " value " + m_nGpioValue + " failed.");
                                    return;
                                }
                            } else
                                return;
                        } else {
                            int nRes = onGetGpio();
                            if(nRes<0) {
                                ShowDialog("Error", "Get " + m_strGPIOValue + " failed.");
                                return;
                            }
                            if (1 == nRes)
                                edtGpio.setText("High");
                            else
                                edtGpio.setText("Low");
                        }
                        //dialog.dismiss(); //if inputValueCheck() return true, dismiss setting dialog,
                        // in return false case, we keep setting dialog.
                    }
                });
            }
        });
    }

    // open PL25x3 port
    private boolean onOpenUsbSerial() {
        Log.d(m_strTAG, "Enter  openUsbSerial");
        if (null == m_Serial) {
            Log.d(m_strTAG, "mSerial is null");
            // get service
            m_Serial = new PL25x3Lib(
                    (UsbManager) getSystemService(Context.USB_SERVICE), this,
                    ACTION_USB_PERMISSION);
            m_nDeviceCount = m_Serial.PL25x3_Enumerate();
            if (0 == m_nDeviceCount) {
                Toast.makeText(this, "no more devices found",
                        Toast.LENGTH_SHORT).show();
                m_nChannelSelectValue = m_nNO_DEVICE_INDEX;
                return false;
            } else {
                Log.d(m_strTAG, "enumerate succeeded!");
                m_nChannelSelectValue = 0;
                m_bIsDeviceOpen = new boolean[4];
                Arrays.fill(m_bIsDeviceOpen, false);
            }
        }
        try {
            Thread.sleep(50); //wait for device ready
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (SHOW_DEBUG) {
            Log.d(m_strTAG, "openUsbSerial : isConnected ");
        }
        if (m_bIsDeviceOpen[m_nChannelSelectValue])
            return true;

        m_nChannelSelectValue = Integer.parseInt(m_strGPIOValue.charAt(1) + "");
        Log.d(m_strTAG, "channelselect" + m_nChannelSelectValue);
        if (m_bIsPL2543) {
            m_nDeviceIndexForOpen = m_nChannelSelectValue;
        } else {
            if (m_nChannelSelectValue == 0 || m_nChannelSelectValue == 1) {
                m_nDeviceIndexForOpen = m_nChannelSelectValue;
            } else {
                m_nDeviceIndexForOpen = 0;
            }
        }
        Log.d(m_strTAG, "m_nDeviceIndexForOpen " + m_nDeviceIndexForOpen);
        if (!m_Serial.PL25x3_OpenDevByUARTSetting(m_nDeviceIndexForOpen, m_nBaudrate, m_DataBits, m_StopBits,
                m_Parity, m_FlowControl)) {
            Log.d(m_strTAG, "Error: fail to openUsbSerial ");
            return false;
        } else {
            Toast.makeText(this, "connected", Toast.LENGTH_SHORT).show();
            Log.d(m_strTAG, "Leave openUsbSerial");
            m_bIsDeviceOpen[m_nChannelSelectValue] = true;
            return true;
        }
    }// openUsbSerial

    // close PL25x3 port
    private void onCloseUsbSerial() {
        Log.d(m_strTAG, "Enter  closeUsbSerial");
        if (m_Serial != null) {
            m_Serial.PL25x3_Close();
            m_Serial = null;
        }
        Log.d(m_strTAG, "Leave  closeUsbSerial");
    }

    //Check input value
    private boolean inputValueCheck(Spinner spn, EditText edt){
        if (spn.getSelectedItemPosition() == 0) { //select send option
            try {
                int nInputValue = Integer.parseInt(edt.getText().toString());
                if( (nInputValue != 0) && (nInputValue != 1)) {//Value isn't 0 or 1, Show Alert
                    ShowDialog("Warning", "Input Value should be 0 or 1.");
                    return false;
                }
                m_nGpioValue = nInputValue;
                return true;
            } catch(NumberFormatException e) {
                ShowDialog("Error", "Please Enter Input Value.");
                e.printStackTrace();
                return false;
            }
        } else
            return true;
    }

    private int onSetGpio() {
        int nRes = -1;
        Log.d(m_strTAG, "Enter onSetGpio");
        if(!onOpenUsbSerial())//OpenDevice
            return nRes;

        Log.d(m_strTAG, "m_nPostionIndex " + m_nChannelSelectValue + " m_nGpioPinNum " + m_nGpioPinNum + " GPIO_MODE_OUTPUT " + GPIO_MODE_OUTPUT);
        nRes = m_Serial.PL25x3_GPIO_ENABLE(m_nChannelSelectValue, m_nGpioPinNum, GPIO_MODE_OUTPUT);
        if (nRes < 0) {
            Log.d(m_strTAG, "GPIO_"+ m_nGpioPinNum +" output enable: failed");
            onCloseUsbSerial();
            return nRes;
        } else {
            Log.d(m_strTAG, "GPIO_"+ m_nGpioPinNum +" output enable: OK");
        }
        nRes = m_Serial.PL25x3_GPIO_Write(m_nChannelSelectValue, m_nGpioPinNum, m_nGpioValue);
        if (nRes < 0) {
            Log.d(m_strTAG, "SetGPIO_"+ m_nGpioPinNum +"_-->" + m_nGpioValue + ": failed");
        } else {
            Log.d(m_strTAG, "SetGPIO_"+ m_nGpioPinNum +"_-->" + m_nGpioValue + ": OK ");
            Toast.makeText(MainActivity.this, "SetGPIO_"+ m_nGpioPinNum +"_-->" + m_nGpioValue + ": OK ", Toast.LENGTH_SHORT).show();
        }
        onCloseUsbSerial();
        return nRes;
    }

    private int onGetGpio() {
        Log.d(m_strTAG, "Enter  GetGPIO_0_Val");
        int nRes = -1;
        int[] nGetValue = new int[2];
        if (!onOpenUsbSerial())//OpenDevice
            return nRes;

        //Set GPIO output disable
        nRes = m_Serial.PL25x3_GPIO_ENABLE(m_nChannelSelectValue, m_nGpioPinNum, GPIO_MODE_INPUT);
        if (nRes < 0) {
            Log.d(m_strTAG, "GPIO_"+ m_nGpioPinNum +" output disable: failed");
            onCloseUsbSerial();
            return nRes;
        } else {
            Log.d(m_strTAG, "GPIO_"+ m_nGpioPinNum +" output disable: OK");
        }
        //Get GPIO value
        nGetValue = m_Serial.PL25x3_GPIO_Read(m_nChannelSelectValue, m_nGpioPinNum);
        if (nGetValue[0] < 0) {
            Log.d(m_strTAG, "Get GPIO_"+ m_nGpioPinNum +"_Val: failed");
            Toast.makeText(MainActivity.this,"Get GPIO_"+ m_nGpioPinNum +"_Val: failed: res: " + nGetValue[0], Toast.LENGTH_SHORT).show();
            onCloseUsbSerial();
            return nGetValue[0];
        } else {
            Log.d(m_strTAG, "GPIO "+ m_nGpioPinNum +" :" + nGetValue[1]);
            Toast.makeText(MainActivity.this,"GPIO "+ m_nGpioPinNum +" :" + nGetValue[1], Toast.LENGTH_SHORT).show();
        }
        onCloseUsbSerial();
        return nGetValue[1];
    }

    private void ShowDialog(String title, String message) {
        new AlertDialog.Builder(MainActivity.this)
                .setTitle(title)
                .setMessage(message)
                .setNegativeButton("OK",null).show();
    }
}