package tw.com.prolific.Pl25x3UartSample;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.ArrayAdapter;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import java.io.IOException;

import tw.com.prolific.pl25x3Lib.PL25x3Lib;

public class MainActivity extends AppCompatActivity {
    private static final String ACTION_USB_PERMISSION = "com.prolific.pl2543_multisimpletest.USB_PERMISSION";

    private static final int DEFAULT_DATA_LENGTH = 64;
    private static final int PACKATE_DATA_LENGTH = 512;

    private static final int MSG_SHOW_INFO = 0x00;
    private static final int MSG_UPDATE_UI = 0x01;

   //UI component
    private EditText m_edtxtBaudRate;
    private Spinner m_spnDataBit;
    private Spinner m_spnStopBit;
    private Spinner m_spnParity;
    private TextView m_txtResult;
    private ScrollView m_scrollViewFortxtResult;
    private EditText m_edtxtData;
    private Button m_btnClear;
    private Button m_btnSend;

    PL25x3Lib m_Serial;
    String m_strTAG = "PL25x3_APLog";
    private int m_nBaudrate = 115200;
    private PL25x3Lib.DataBits m_DataBits = PL25x3Lib.DataBits.D8;
    private PL25x3Lib.Parity m_Parity = PL25x3Lib.Parity.NONE;
    private PL25x3Lib.StopBits m_StopBits = PL25x3Lib.StopBits.S1;
    private PL25x3Lib.FlowControl m_FlowControl = PL25x3Lib.FlowControl.OFF;

    private final static int m_nDeviceVid = 0x067b;
    private int m_nUsbDeviceCount = 0;
    private int m_nDeviceIndex = 0;
    //Usb Permission
    private PendingIntent m_pendingIntent;
    private IntentFilter m_intentFilter;
    private byte[] m_byWriteBuffer = null;

    private final String INFO_MESSAGE = "infoBody";
    private String m_strLog = "";
    Thread readThread = null;
    boolean m_bIsStopRead = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        m_edtxtBaudRate = (EditText) findViewById(R.id.edtxtBaudRate);
        m_edtxtBaudRate.addTextChangedListener(new OnBaudrateTextWatchr());

        m_spnDataBit = (Spinner) findViewById(R.id.spnDatabit);
        ArrayAdapter<String> dataBitAdapter = new ArrayAdapter<String>(this, R.layout.custom_spinner, getResources().getStringArray(R.array.DataBit));
        dataBitAdapter.setDropDownViewResource(R.layout.custom_spinner_item);
        m_spnDataBit.setAdapter(dataBitAdapter);
        m_spnDataBit.setOnItemSelectedListener(new OnDataBitItemSelectedListener());

        m_spnStopBit = (Spinner) findViewById(R.id.spnStopBit);
        ArrayAdapter<String> stopBitAdapter = new ArrayAdapter<String>(this, R.layout.custom_spinner, getResources().getStringArray(R.array.StopBit));
        stopBitAdapter.setDropDownViewResource(R.layout.custom_spinner_item);
        m_spnStopBit.setAdapter(stopBitAdapter);
        m_spnStopBit.setOnItemSelectedListener(new OnStopBitItemSelectedListener());

        m_spnParity = (Spinner) findViewById(R.id.spnParity);
        ArrayAdapter<String> parityAdapter = new ArrayAdapter<String>(this, R.layout.custom_spinner, getResources().getStringArray(R.array.Parity));
        parityAdapter.setDropDownViewResource(R.layout.custom_spinner_item);
        m_spnParity.setAdapter(parityAdapter);
        m_spnParity.setOnItemSelectedListener(new OnParityItemSelectedListener());

        m_txtResult = (TextView) findViewById(R.id.txtResult);
        m_scrollViewFortxtResult = (ScrollView) findViewById(R.id.scrollViewFortxtResult);
        m_edtxtData = (EditText) findViewById(R.id.edtxtData);

        // get service
        m_Serial = new PL25x3Lib(
                (UsbManager) getSystemService(Context.USB_SERVICE), this, ACTION_USB_PERMISSION);

        //Step1: Register the broadcast receiver in onCreate() method
        m_intentFilter = new IntentFilter(ACTION_USB_PERMISSION);
        m_intentFilter.addAction(UsbManager.ACTION_USB_DEVICE_ATTACHED);
        m_intentFilter.addAction(UsbManager.ACTION_USB_DEVICE_DETACHED);
        if (broadCastUsbReceiver != null) {
            registerReceiver(broadCastUsbReceiver, m_intentFilter);
        }
        //Setup Default Value = BaudRate:115200, DataBits:8, StopBits:1, Parity:NONE
        m_edtxtBaudRate.setText("115200");
        m_spnDataBit.setSelection(3);
        m_spnStopBit.setSelection(0);
        m_spnParity.setSelection(0);
    }

    protected void onDestroy() {
        Log.d(m_strTAG, "onDestroy");
        try {
            if (readThread != null && readThread.isAlive()) {
                m_bIsStopRead = true;
                readThread.join();
                readThread = null;
                Log.d(m_strTAG, "onDestroy Stop ReadThread.");
            }
        } catch (InterruptedException e) {
            Log.d(m_strTAG, "onDestroy Stop ReadThread exception.");
            e.printStackTrace();
            readThread = null;
        }
        if (0 != m_nUsbDeviceCount) {
            unregisterReceiver(this.broadCastUsbReceiver);
        }
        super.onDestroy();
    }

    public void onStart() {
        super.onStart();
        Log.d(m_strTAG, "Enter onStart");
        //enum device
        m_nUsbDeviceCount = m_Serial.PL25x3_Enumerate();
        if (0 == m_nUsbDeviceCount) {
            Toast.makeText(this, "no more devices found", Toast.LENGTH_SHORT).show();
        } else {
            boolean bIsOpen = m_Serial.PL25x3_OpenDevByDefualtSetting(m_nDeviceIndex);
            if (bIsOpen != true) {
                Log.d(m_strTAG, "Open device failed.");
            }
            Log.d(m_strTAG, "m_nUsbDeviceCount=" + m_nUsbDeviceCount);
            Toast.makeText(this, "attached", Toast.LENGTH_SHORT).show();
            try {
                if (readThread == null) {
                    readThread = new Thread(readRunnable);
                    readThread.start();
                } else if (!readThread.isAlive()) {
                    readThread.join();
                    readThread = null;
                    readThread = new Thread(readRunnable);
                    readThread.start();
                }
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Log.d(m_strTAG, "Leave onStart");
    }

    private final BroadcastReceiver broadCastUsbReceiver = new BroadcastReceiver() {
        public void onReceive(Context context, Intent intent) {
            Log.d(m_strTAG, "BroadcastReceiver-onReceive");
            String strAction = intent.getAction();
            if (strAction.equals(ACTION_USB_PERMISSION)) {
                Log.d(m_strTAG, "DEFINE_ACTION_USB_PERMISSION");
                synchronized (this) {
                    UsbDevice usbDevice = intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);
                    if (intent.getBooleanExtra(UsbManager.EXTRA_PERMISSION_GRANTED, false)) {
                        if (usbDevice != null) {
                            String strDeviceName = usbDevice.getDeviceName();
                            Log.d(m_strTAG, "%s Attached " + strDeviceName);
                            m_nUsbDeviceCount = m_Serial.PL25x3_Enumerate();
                            if(m_nUsbDeviceCount > 0) {
                                boolean bIsOpen = m_Serial.PL25x3_OpenDevByDefualtSetting(m_nDeviceIndex);
                                if (bIsOpen != true) {
                                    Log.d(m_strTAG, "Open device failed.");
                                }
                            }
                            try {
                                if (readThread == null) {
                                    readThread = new Thread(readRunnable);
                                    readThread.start();
                                } else if (!readThread.isAlive()) {
                                    readThread.join();
                                    readThread = null;
                                    readThread = new Thread(readRunnable);
                                    readThread.start();
                                }
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        Log.d(m_strTAG, "Request Permission Pass");
                    } else {
                        Log.d(m_strTAG, "Request Permission Fail");
                    }
                }
            }
            if (UsbManager.ACTION_USB_DEVICE_ATTACHED.equals(strAction)) {
                Log.d(m_strTAG, "ACTION_USB_DEVICE_ATTACHED");
                synchronized (this) {
                    m_nUsbDeviceCount = m_Serial.PL25x3_Enumerate();
                    if(m_nUsbDeviceCount > 0) {
                        boolean bIsOpen = m_Serial.PL25x3_OpenDevByDefualtSetting(m_nDeviceIndex);
                        if (bIsOpen != true) {
                            Log.d(m_strTAG, "Open device failed.");
                        }
                    }
                    try {
                        if (readThread == null) {
                            readThread = new Thread(readRunnable);
                            readThread.start();
                        } else if (!readThread.isAlive()) {
                            readThread.join();
                            readThread = null;
                            readThread = new Thread(readRunnable);
                            readThread.start();
                        }
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                Log.d(m_strTAG, "attached");
            }
            if (UsbManager.ACTION_USB_DEVICE_DETACHED.equals(strAction)) {
                Log.d(m_strTAG, "ACTION_USB_DEVICE_DETACHED");
                //Remove Device, Cleans and closes communication with the device
                synchronized (this) {
                    m_nUsbDeviceCount = m_Serial.PL25x3_Enumerate();
                    try {
                        if (readThread.isAlive()) {
                            m_bIsStopRead = true;
                            readThread.join();
                            readThread = null;
                            Log.d(m_strTAG, "detached Stop ReadThread.");
                        }
                    } catch (InterruptedException e) {
                        Log.d(m_strTAG, "detached Stop ReadThread exception");
                        e.printStackTrace();
                        readThread = null;
                    }
                }
                Log.d(m_strTAG, "DeivceCount=" + m_nUsbDeviceCount);
            }
        }//onReceive
    };

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_main, menu);
        return true;
    }

    //Menu item event
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle item selection
        switch (item.getItemId()) {
            case R.id.action_about:
                onAbout();
                return true;
            case R.id.action_finish:
                onFinishTest();
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    //menu about event
    void onAbout() {
        //show about
        String strVersion = "";
        strVersion = m_Serial.PL25x3_GetSdkVersion();
        strVersion = "SDK版本: " + strVersion;

        AlertDialog.Builder alertDialog = new AlertDialog.Builder(this);
        alertDialog.setTitle(R.string.about);
        alertDialog.setMessage(strVersion);
        alertDialog.setPositiveButton("確定", null);
        alertDialog.show();
    }

    //menu finish event
    void onFinishTest() {
        finish();
    }

    //btnSend event
    public void onSend(View view) {
        try {
            byte[] data = m_edtxtData.getText().toString().getBytes();
            if (data.length == 0) {
                Toast.makeText(MainActivity.this, "No data.", Toast.LENGTH_SHORT).show();
                return;
            }
            if (null == m_Serial)
                return;
            if(0 == m_nUsbDeviceCount){
                ShowInfo("No DEVICE!");
                return;
            }

            Log.d(m_strTAG, "Enter onSend");

            if (m_DataBits == PL25x3Lib.DataBits.D5)
                FillDataBuffer(data, 0x1F);
            else if (m_DataBits == PL25x3Lib.DataBits.D6)
                FillDataBuffer(data, 0x3F);
            else if (m_DataBits == PL25x3Lib.DataBits.D7)
                FillDataBuffer(data, 0x7F);
            else
                FillDataBuffer(data, 0xFF);

            ShowInfo("Data processing OK!!" + "\nUse DataLength: " + data.length + " bytes");
            //Set Uart Config
            int res = m_Serial.PL25x3_SetupCOMPort(m_nDeviceIndex, m_nBaudrate, m_DataBits, m_StopBits, m_Parity, m_FlowControl);
            if (res < 0) {
                Log.d(m_strTAG, "onSend set config failed.");
                ShowInfo("Set uart config failed before write data. res: " + res);
                return;
            }

            //Starting write Data
            int remainLength = data.length, nPackageLength = 0;
            int nDataStart = 0;
            byte[] byTempWriteBuffer;

            while (remainLength != 0) {
                if (remainLength < PACKATE_DATA_LENGTH) {
                    nPackageLength = remainLength;
                    remainLength = 0;
                } else {
                    nPackageLength = PACKATE_DATA_LENGTH;
                    remainLength -= PACKATE_DATA_LENGTH;
                }
                byTempWriteBuffer = new byte[nPackageLength];

                //src, start, dist, start
                System.arraycopy(m_byWriteBuffer, nDataStart, byTempWriteBuffer, 0, nPackageLength);

                res = m_Serial.PL25x3_Write(m_nDeviceIndex, byTempWriteBuffer);
                if (res < 0) {
                    Log.d(m_strTAG, "UART_Write failed.");
                    ShowInfo("UART_Write failed. res: " + res);
                    m_Serial.PL25x3_Close();
                    return;
                }
                Log.d(m_strTAG, "Write data " + nPackageLength + " bytes");
                nDataStart += nPackageLength;
            }//finish write data

            Log.d(m_strTAG, "Leave onSend.");
            ShowInfo("Writing Data Finished.");
        } catch (NullPointerException | IOException e) {
            Toast.makeText(MainActivity.this, "No data2.", Toast.LENGTH_SHORT).show();
            e.printStackTrace();
        }
    }

    private Runnable readRunnable = new Runnable() { //Read Thread

        @Override
        public void run() {
            if (null == m_Serial)
                return;
            if(0 == m_nUsbDeviceCount)
                return;
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            Log.d(m_strTAG, "Enter readRunnable");

            int res = 0;
            try {
                res = m_Serial.PL25x3_SetupCOMPort(m_nDeviceIndex, m_nBaudrate, m_DataBits, m_StopBits, m_Parity, m_FlowControl);
            } catch (IOException e) {
                e.printStackTrace();
            }
            if (res < 0) {
                Log.d(m_strTAG, "readRunnable setUartConfig Failed.");
                ShowInfo("readRunnable setUartConfig Failed" + res);
                return;
            }
            ShowInfo("Starting Reading Data");

            byte[] readBuffer = new byte[DEFAULT_DATA_LENGTH];
            while (true) {
                try {
                    if (m_bIsStopRead) {
                        Log.d(m_strTAG, "readRunnable Stopped.");
                        ShowInfo("readRunnable Stopped.");
                        m_bIsStopRead = false;
                        break;
                    }
                    res = m_Serial.PL25x3_Read(m_nDeviceIndex, readBuffer);
                    if (res <= 0) {
                        Log.d(m_strTAG, "readRunnable uartRead Failed.");
                        continue;
                    } else { //Read data success
                        ShowInfo("readRunnable read data success.");
                        String str = new String(readBuffer);
                        ShowInfo(str);
                        readBuffer = new byte[DEFAULT_DATA_LENGTH];
                    }

                    Thread.sleep(100);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                    ShowInfo("readRunnable Thread InterruptedException.");
                    return;
                }
            }
            ShowInfo("readRunnable Thread Finished.");
        }
    };

    //btnClear event
    public void onClear(View view) {
        showLog("", true);
    }

    synchronized public void showLog(String strLog, boolean isClear) {
        if (isClear)
            m_strLog = "";
        m_strLog = m_strLog + '\n' + strLog;
        m_txtResult.setText(m_strLog);
        m_scrollViewFortxtResult.fullScroll(ScrollView.FOCUS_DOWN);
    }

    private void ShowInfo(String str) {
        Message msg = new Message();
        msg.what = MSG_SHOW_INFO;
        Intent intent = new Intent();
        intent.putExtra(INFO_MESSAGE, str);
        msg.obj = intent;
        mHandler.sendMessage(msg);
    }

    @SuppressLint("HandlerLeak")
    Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MSG_SHOW_INFO:
                    String str1 = ((Intent) msg.obj).getExtras().getString(INFO_MESSAGE);
                    showLog(str1, false);
                    break;
            }
            super.handleMessage(msg);
        }
    };

    private void FillDataBuffer(byte[] byBuffer, int dwMaskChar) {
        int nDataLength = byBuffer.length;
        m_byWriteBuffer = new byte[nDataLength];
        for (int index = 0; index < nDataLength; index++)
            m_byWriteBuffer[index] = (byte) (byBuffer[index] & dwMaskChar);
    }

    public class OnStopBitItemSelectedListener implements AdapterView.OnItemSelectedListener {
        public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
            if (null == m_Serial) {
                ShowInfo("Library not Open.");
                return;
            }
            if (position == 1)
                m_StopBits = PL25x3Lib.StopBits.S2;
            else
                m_StopBits = PL25x3Lib.StopBits.S1;

        }//public void onItemSelected

        public void onNothingSelected(AdapterView<?> parent) {
            // Do nothing.
        }
    }//OnStopBitItemSelectedListener

    public class OnDataBitItemSelectedListener implements AdapterView.OnItemSelectedListener {
        public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
            if (null == m_Serial) {
                ShowInfo("Library not Open.");
                return;
            }
            switch (position) {
                case 0:
                    m_DataBits = PL25x3Lib.DataBits.D5;
                    break;
                case 1:
                    m_DataBits = PL25x3Lib.DataBits.D6;
                    break;
                case 2:
                    m_DataBits = PL25x3Lib.DataBits.D7;
                    break;
                default:
                    m_DataBits = PL25x3Lib.DataBits.D8;
                    break;
            }
        }//public void onItemSelected

        public void onNothingSelected(AdapterView<?> parent) {
            // Do nothing.
        }
    }//OnDataBitItemSelectedListener

    public class OnParityItemSelectedListener implements AdapterView.OnItemSelectedListener {
        public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
            if (null == m_Serial) {
                ShowInfo("Library not Open.");
                return;
            }
            switch (position) {
                case 1:
                    m_Parity = PL25x3Lib.Parity.ODD;
                    break;
                case 2:
                    m_Parity = PL25x3Lib.Parity.EVEN;
                    break;
                default:
                    m_Parity = PL25x3Lib.Parity.NONE;
                    break;
            }
        }//public void onItemSelected

        public void onNothingSelected(AdapterView<?> parent) {
            // Do nothing.
        }
    }//OnParityItemSelectedListener

    public class OnBaudrateTextWatchr implements TextWatcher {

        @Override
        public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
        }

        @Override
        public void afterTextChanged(Editable editable) {
            //get Clock value,and covert clock to Hz
            if (null == m_Serial) {
                ShowInfo("Library not Open.");
                return;
            }
            if(editable.toString().length() > 0)
                m_nBaudrate = Integer.parseInt(editable.toString());
        }
    }
}
