#ifndef __HID_SDK_API_H__
#define __HID_SDK_API_H__

#include <wchar.h>

typedef void*                   HANDLE;
typedef unsigned char           uint8_t;
typedef unsigned short          uint16_t;
typedef unsigned int            uint32_t;
typedef unsigned long long      uint64_t;

typedef signed char             int8_t;
typedef short                   int16_t;
typedef int                     int32_t;
typedef long long               int64_t;

#define ERR_HID_SUCCESS                    0
#define ERR_HID_DEVICE_NOT_FOUND           -1001
#define ERR_HID_OPEN_DEVICE_FAIL           -1002
#define ERR_HID_CLOSE_DEVICE_FAIL          -1003
#define ERR_HID_DEVICE_DISCONNETED         -1004
#define ERR_HID_SET_REPORT_FAIL            -1005
#define ERR_HID_GET_REPORT_FAIL            -1006
#define ERR_HID_INVALID_ARGUMENT           -1007
#define ERR_HID_READ_DATA_TIMEOUT          -1008
#define ERR_HID_READ_DATA_FAIL             -1009
#define ERR_HID_READ_DATA_INCORRECT_LENGTH -1010
#define ERR_HID_I2C_BUS_BUSY               -1011
#define ERR_HID_I2C_PROCESSING             -1012
#define ERR_HID_I2C_ADDRESS_NACK           -1013
#define ERR_HID_I2C_DATA_NACK              -1014
#define ERR_HID_I2C_CHECK_STATUS_FAIL      -1015

// GPIO
enum GPIO_CHANNEL_SELECT {
    GPIO_CHANNEL_SELECT_CH0 = 0,
    GPIO_CHANNEL_SELECT_CH1,
    GPIO_CHANNEL_SELECT_CH2,
    GPIO_CHANNEL_SELECT_CH3
};

enum GPIO_PORT_NUMBER {
    GPIO_PORT_NUMBER_2 = 2,
    GPIO_PORT_NUMBER_3,
    GPIO_PORT_NUMBER_4,
    GPIO_PORT_NUMBER_5,
    GPIO_PORT_NUMBER_6,
    GPIO_PORT_NUMBER_7,
    GPIO_PORT_NUMBER_10 = 10,
};

enum GPIO_VALUE {
    GPIO_VALUE_LOW = 0,
    GPIO_VALUE_HIGH,
};

enum GPIO_DIR {
    GPIO_DIR_INPUT = 0,
    GPIO_DIR_OUTPUT
};

//UART
enum UART_STOP_BIT {
    UART_ONE_STOP_BIT = 0,
    UART_ONE_POINT_FIVE_STOP_BIT = 1,
    UART_TWO_STOP_BIT = 2,
};

enum UART_PARITY_TYPE {
    UART_PARITY_NONE = 0,
    UART_PARITY_ODD = 1,
    UART_PARITY_EVEN = 2,
    UART_PARITY_MARK = 3,
    UART_PARITY_SPACE = 4,
};

enum UART_DATA_BIT {
    UART_DATA_BIT_5 = 5,
    UART_DATA_BIT_6 = 6,
    UART_DATA_BIT_7 = 7,
    UART_DATA_BIT_8 = 8,
};

// SPI
enum SPI_MODE {
    SPI_MODE_0 = 0,
    SPI_MODE_1,
    SPI_MODE_2,
    SPI_MODE_3
};

enum SPI_SELECT {
    SPI_SELECT_0 = 0,
    SPI_SELECT_1,
    SPI_SELECT_2,
    SPI_SELECT_3
};

enum SPI_CS_STATE {
    SPI_CS_STATE_LOW = 0,
    SPI_CS_STATE_HIGH,
};

struct HIDDeviceInfo {
    uint16_t vendor;
    uint16_t product;
    wchar_t *productString;
    uint32_t locationID;
    uint8_t interfaceNumber;
};

#ifdef __cplusplus
extern "C" {
#endif
    
//SDK Version
void GetSDKVersion(uint32_t *SdkVersion);

//Device API Start
int32_t GetDeviceHandleListByVid(uint16_t VID, HANDLE **DeviceHandleList, uint8_t *DeviceCount);
int32_t GetDeviceHandleListByVidPid(uint16_t VID, uint16_t PID, HANDLE **DeviceHandleList, uint8_t *DeviceCount);
void FreeDeviceHandleList(HANDLE **DeviceHandleList);
int32_t OpenDeviceHandle(HANDLE *hDeviceHandle);
int32_t CloseDeviceHandle(HANDLE *hDeviceHandle);
int32_t GetDeviceInfo(HANDLE *hDeviceHandle, struct HIDDeviceInfo *DeviceInfo);
//Device API End

//UART API Start
int32_t GetUartConfig(HANDLE *hDeviceHandle, uint32_t *BaudRate, enum UART_STOP_BIT *StopBit, enum UART_PARITY_TYPE *ParityType, enum UART_DATA_BIT *DataBit);
int32_t SetUartConfig(HANDLE *hDeviceHandle, uint32_t BaudRate, enum UART_STOP_BIT StopBit, enum UART_PARITY_TYPE ParityType, enum UART_DATA_BIT DataBit);
int32_t UartWrite(HANDLE *hDeviceHandle, uint8_t *Buffer, uint16_t NumberOfBytesToWrite, uint16_t *NumberOfBytesWritten);
int32_t UartRead(HANDLE *hDeviceHandle, uint8_t *Buffer, uint16_t NumberOfBytesToRead, uint16_t *NumberOfBytesRead, uint32_t TimeOutms);
int32_t UartReset(HANDLE *hDeviceHandle);
//UART API End

//I2C API Start
int32_t SetI2CFrequency(HANDLE *hDeviceHandle, uint8_t FreqDiv);
int32_t I2CWrite(HANDLE *hDeviceHandle, uint8_t DeviceAddr, uint8_t *Buffer, uint16_t NumberOfBytesToWrite, uint16_t *NumberOfBytesWritten);
int32_t I2CRead(HANDLE *hDeviceHandle, uint8_t DeviceAddr, uint8_t *Buffer, uint16_t NumberOfBytesToRead, uint16_t *NumberOfBytesRead, uint32_t TimeOutms);
int32_t I2CWriteRead(HANDLE *hDeviceHandle, uint8_t DeviceAddr, uint8_t *WriteBuffer, uint16_t NumberOfBytesToWrite, uint8_t *ReadBuffer, uint16_t NumberOfBytesToRead, uint16_t *NumberOfBytesRead, uint32_t TimeOutms);
int32_t I2CReset(HANDLE *hDeviceHandle);
//I2C API End

//SPI API Start
int32_t SetSPIFrequency(HANDLE *hDeviceHandle, uint8_t FreqDiv);
int32_t SetSPIMode(HANDLE *hDeviceHandle, enum SPI_MODE spiMode);
int32_t SPIWrite(HANDLE *hDeviceHandle, enum SPI_SELECT SelectSPI, uint8_t *Buffer, uint16_t NumberOfBytesToWrite, uint16_t *NumberOfBytesWritten);
int32_t SPIRead(HANDLE *hDeviceHandle, enum SPI_SELECT SelectSPI, uint8_t *Buffer, uint16_t NumberOfBytesToRead, uint16_t *NumberOfBytesRead, uint32_t TimeOutms);
int32_t SPIWriteRead(HANDLE *hDeviceHandle, enum SPI_SELECT SelectSPI, uint8_t *WriteBuffer, uint16_t NumberOfBytesToWrite, uint8_t *ReadBuffer, uint16_t NumberOfBytesToRead, uint16_t *NumberOfBytesRead, uint32_t TimeOutms);
int32_t SPIFullDuplexWriteRead(HANDLE *hDeviceHandle, enum SPI_SELECT SelectSPI, uint8_t *WriteBuffer, uint16_t NumberOfBytesToWrite, uint8_t *ReadBuffer, uint16_t NumberOfBytesToRead, uint16_t *NumberOfBytesRead, uint32_t TimeOutms);
int32_t SPIFullDuplexWriteRead2(HANDLE *hDeviceHandle, enum SPI_SELECT SelectSPI, uint8_t *WriteBuffer, uint32_t NumberOfBytesToWrite, uint8_t *ReadBuffer, uint32_t NumberOfBytesToRead, uint32_t *NumberOfBytesRead, uint32_t TimeOutms);
int32_t SPISetCS(HANDLE *hDeviceHandle, enum SPI_SELECT SelectSPI, enum SPI_CS_STATE CSState);
int32_t SPIReset(HANDLE *hDeviceHandle);
//SPI API End
    
//GPIO API Start
int32_t SetGPIODir(HANDLE *hDeviceHandle, enum GPIO_CHANNEL_SELECT Channel, enum GPIO_PORT_NUMBER PortNumber, enum GPIO_DIR GPIODir);
int32_t SetGPIO(HANDLE *hDeviceHandle, enum GPIO_CHANNEL_SELECT Channel, enum GPIO_PORT_NUMBER PortNumber, enum GPIO_VALUE Value);
int32_t GetGPIO(HANDLE *hDeviceHandle, enum GPIO_CHANNEL_SELECT Channel, enum GPIO_PORT_NUMBER PortNumber, uint8_t *Value);
//GPIO API End
    
#ifdef __cplusplus
}
#endif

#endif





