#import <Foundation/Foundation.h>
#import <HidSdkApi/HidSdkApi.h>

int main(int argc, const char * argv[]) {
    @autoreleasepool {
        HANDLE *deviceHandleList = NULL;
        uint8_t deviceCount = 0;
        int32_t ret = ERR_HID_SUCCESS;
        HANDLE *deviceHandle = NULL;
        uint32_t timeout_msec = 10*1000;
        uint32_t baudRate;
        enum UART_STOP_BIT stopBit;
        enum UART_PARITY_TYPE parity;
        enum UART_DATA_BIT dataBit;
        uint8_t length = 10;
        uint8_t writeBuffer[11] = {'0','1','2','3','4','5','6','7','8','9','\0'};
        uint16_t writtenLength = 0;
        uint8_t readBuffer[11] = {0};
        uint16_t readLength = 0;
        uint32_t sdkVersion = 0;
        
        GetSDKVersion(&sdkVersion);
        printf("SDK Version:0x%x\n", sdkVersion);
        
        ret = GetDeviceHandleListByVidPid(0x67b, 0x2561, &deviceHandleList, &deviceCount);
        if (ret != ERR_HID_SUCCESS || deviceCount == 0) {
            printf("UART get deivce handle list failed, status:%d, device count:%d\n", ret, deviceCount);
            return -1;
        }
        
        for (int i = 0; i < deviceCount; i++) {
            struct HIDDeviceInfo deviceInfo = {0};
            HANDLE *tempDeviceHandle = deviceHandleList[i];
            ret = GetDeviceInfo(tempDeviceHandle, &deviceInfo);
            if (ret != ERR_HID_SUCCESS) {
                printf("UART get device info failed, status:%d\n", ret);
                goto EXIT;
            }
            if (deviceInfo.interfaceNumber == 0) {
                deviceHandle = tempDeviceHandle;
                break;
            }
        }
        
        if (deviceHandle == NULL) {
            printf("UART  device handle not found\n");
            goto EXIT;
        }
        
        ret = OpenDeviceHandle(deviceHandle);
        if (ret != ERR_HID_SUCCESS) {
            printf("UART open device handle failed, status:%d\n", ret);
            goto EXIT;
        }
        
        ret = SetUartConfig(deviceHandle, 115200, UART_ONE_STOP_BIT, UART_PARITY_NONE, UART_DATA_BIT_8);
        if (ret != ERR_HID_SUCCESS) {
            printf("UART set uart configure failed, status:%d\n", ret);
            goto EXIT;
        }
        
        ret = GetUartConfig(deviceHandle, &baudRate, &stopBit, &parity, &dataBit);
        if (ret != ERR_HID_SUCCESS) {
            printf("UART get uart configure failed, status:%d\n", ret);
            goto EXIT;
        } else {
            printf("UART baud rate:%u, stop bit:%d, parity:%d, data bit:%d\n", baudRate, stopBit, parity, dataBit);
        }
        
        printf("UART write data %s\n", writeBuffer);
        ret = UartWrite(deviceHandle, writeBuffer, length, &writtenLength);
        if (ret != ERR_HID_SUCCESS) {
            printf("UART write data failed, status:%d\n", ret);
            goto EXIT;
        }
        
        readBuffer[10] = '\0';
        ret = UartRead(deviceHandle, readBuffer, length, &readLength, timeout_msec);
        if (ret != ERR_HID_SUCCESS) {
            printf("UART read data failed, status:%d\n", ret);
        } else {
            printf("UART read data %s\n", readBuffer);
        }
        
    EXIT:
        ret = CloseDeviceHandle(deviceHandle);
        FreeDeviceHandleList(&deviceHandleList);
    }
    
    return 0;
}
