#import <Foundation/Foundation.h>
#import <HidSdkApi/HidSdkApi.h>

int main(int argc, const char * argv[]) {
    @autoreleasepool {
        HANDLE *deviceHandleList = NULL;
        uint8_t deviceCount = 0;
        int32_t ret = ERR_HID_SUCCESS;
        HANDLE *deviceHandle = NULL;
        uint32_t timeout_msec = 1000;
        uint8_t slaveDeviceAddress = 0xA0;
        uint8_t currentFreqDiv = 59; // I2C freq(KHz) = 96000/((currentFreqDiv*2+1)*2) = 403 Khz
        uint16_t writtenLength = 0;
        uint16_t readBackLength = 0;
        uint32_t delay_us = 5*1000; // 5ms
        uint32_t sdkVersion = 0;
        
        //Start Address: 0x00
        //AT24C02
        uint8_t writeBuffer[9] = {0x00,'I', '2', 'C', 'T', 'e', 's', 't' ,'\0'};
        uint8_t readBuffer[8] = {0};
        
        GetSDKVersion(&sdkVersion);
        printf("SDK Version:0x%x\n", sdkVersion);
        
        ret = GetDeviceHandleListByVidPid(0x67b, 0x2561, &deviceHandleList, &deviceCount);
        if (ret != ERR_HID_SUCCESS || deviceCount == 0) {
            printf("I2C get deivce handle list failed, status:%d, device count:%d\n", ret, deviceCount);
            return -1;
        }
        
        for (int i = 0; i < deviceCount; i++) {
            struct HIDDeviceInfo deviceInfo = {0};
            HANDLE *tempDeviceHandle = deviceHandleList[i];
            ret = GetDeviceInfo(tempDeviceHandle, &deviceInfo);
            if (ret != ERR_HID_SUCCESS) {
                printf("I2C get device info failed, status:%d\n", ret);
                goto EXIT;
            }
            if (deviceInfo.interfaceNumber == 1) {
                deviceHandle = tempDeviceHandle;
                break;
            }
        }
        
        if (deviceHandle == NULL) {
            printf("I2C  device handle not found\n");
            goto EXIT;
        }
        
        ret = OpenDeviceHandle(deviceHandle);
        if (ret != ERR_HID_SUCCESS) {
            printf("I2C open device handle failed, status:%d\n", ret);
            goto EXIT;
        }
        
        ret = SetI2CFrequency(deviceHandle, currentFreqDiv);
        if (ret != ERR_HID_SUCCESS) {
            printf("I2C Set I2C frequency failed, status:%d\n", ret);
            goto EXIT;
        }
        
        // AT24C02 page write
        // Start Address: 0x00
        // Data : A string "I2CTest\0", \0 means NULL_character
        // Length : 8 bytes + 1 bytes Start Address
        ret = I2CWrite(deviceHandle, slaveDeviceAddress, writeBuffer, 9, &writtenLength);
        if (ret != ERR_HID_SUCCESS) {
            printf("I2C write failed, status:%d\n", ret);
            goto EXIT;
        }
        printf("I2C write data: %s\n", &writeBuffer[1]);
        
        // After the process of write, needs sleep to wait the i2c write is finished
        // The delay time is depended on the application
        usleep(delay_us);
        
        // AT24C02 random read command
        // Write address first, and then, read data
        // Start Address: 0x00
        // Length: 8 bytes
        writeBuffer[0] = 0x00;
        ret = I2CWriteRead(deviceHandle, slaveDeviceAddress, writeBuffer, 1, readBuffer, 8, &readBackLength, timeout_msec);
        
        if (ret != ERR_HID_SUCCESS) {
            printf("I2C read failed, status:%d\n", ret);
            goto EXIT;
        } else {
            printf("I2C read data: %s\n", readBuffer);
        }

    EXIT:
        ret = CloseDeviceHandle(deviceHandle);
        FreeDeviceHandleList(&deviceHandleList);
    }
    return 0;
}
