#import <Foundation/Foundation.h>
#import <HidSdkApi/HidSdkApi.h>

int main(int argc, const char * argv[]) {
    @autoreleasepool {
        HANDLE *deviceHandleList = NULL;
        uint8_t deviceCount = 0;
        int32_t ret = ERR_HID_SUCCESS;
        HANDLE *deviceHandle = NULL;
        enum GPIO_CHANNEL_SELECT channel = GPIO_CHANNEL_SELECT_CH3;
        enum GPIO_PORT_NUMBER portNumber = GPIO_PORT_NUMBER_10;
        uint8_t readValue = 0;
        uint8_t writeValue = 1;
        uint32_t sdkVersion = 0;

        GetSDKVersion(&sdkVersion);
        printf("SDK Version:0x%x\n", sdkVersion);

        ret = GetDeviceHandleListByVidPid(0x67b, 0x2561, &deviceHandleList, &deviceCount);
        if (ret != ERR_HID_SUCCESS || deviceCount == 0) {
            printf("GPIO get deivce handle list failed, status:%d, device count:%d\n", ret, deviceCount);
            return -1;
        }

        deviceHandle = (HANDLE *)deviceHandleList[0];

        ret = OpenDeviceHandle(deviceHandle);
        if (ret != ERR_HID_SUCCESS) {
            printf("GPIO open device handle failed, status:%d\n", ret);
            goto EXIT;
        }

        ret = SetGPIODir(deviceHandle, channel, portNumber, GPIO_DIR_OUTPUT);
        if (ret != ERR_HID_SUCCESS) {
            printf("GPIO set dir failed, status:%d\n", ret);
            goto EXIT;
        }

        ret = SetGPIO(deviceHandle, channel, portNumber, (enum GPIO_VALUE)writeValue);
        if (ret != ERR_HID_SUCCESS) {
            printf("GPIO set failed, status:%d\n", ret);
            goto EXIT;
        }

        ret = GetGPIO(deviceHandle, channel, portNumber, &readValue);
        if (ret != ERR_HID_SUCCESS) {
            printf("GPIO get failed, status:%d\n", ret);
            goto EXIT;
        }
        printf("GPIO value:%d\n", readValue);

    EXIT:
        ret = CloseDeviceHandle(deviceHandle);
        FreeDeviceHandleList(&deviceHandleList);
    }
    return 0;
}
