#include <stdio.h>
#include <string.h>
#include "HidSdkApi.h"

int main() {
    HANDLE *deviceHandleList = NULL;
    uint8_t deviceCount = 0;
    int32_t ret = ERR_HID_SUCCESS;
    HANDLE *deviceHandle = NULL;
    uint32_t timeout_msec = 1000;
    uint8_t currentFreqDiv = 8; // SPI freq(KHz) = 64000/(2*currentFreqDiv) = 4000 Khz
    uint8_t spiCommand = 0;
    uint8_t readBuffer[3] = {0};
    uint16_t writtenLength = 0;
    uint16_t readBackLength = 0;
    uint32_t sdkVersion = 0;
    
    GetSDKVersion(&sdkVersion);
    printf("SDK Version:0x%x\n", sdkVersion);
    
    ret = InitDevice();
    if (ret != ERR_HID_SUCCESS) {
        return -1;
    }
    
    ret = GetDeviceHandleListByVidPid(0x67b, 0x2561, &deviceHandleList, &deviceCount);
    if (ret != ERR_HID_SUCCESS || deviceCount == 0) {
        printf("SPI get deivce handle list failed, status:%d, device count:%d\n", ret, deviceCount);
        return -1;
    }
    
    for (int i = 0; i < deviceCount; i++) {
        struct HIDDeviceInfo deviceInfo = {0};
        HANDLE *tempDeviceHandle = (HANDLE *)deviceHandleList[i];
        ret = GetDeviceInfo(tempDeviceHandle, &deviceInfo);
        if (ret != ERR_HID_SUCCESS) {
            printf("SPI get device info failed, status:%d\n", ret);
            goto EXIT;
        }
        if (deviceInfo.interfaceNumber == 2) {
            deviceHandle = tempDeviceHandle;
            break;
        }
    }
    
    if (deviceHandle == NULL) {
        printf("SPI device handle not found\n");
        goto EXIT;
    }
    
    ret = OpenDeviceHandle(deviceHandle);
    if (ret != ERR_HID_SUCCESS) {
        printf("SPI open device handle failed, status:%d\n", ret);
        goto EXIT;
    }
    
    ret = SetSPIFrequency(deviceHandle, currentFreqDiv);
    if (ret != ERR_HID_SUCCESS) {
        printf("SPI set frequency failed, status:%d\n", ret);
        goto EXIT;
    }
    
    ret = SetSPIMode(deviceHandle, SPI_MODE_3);
    if (ret != ERR_HID_SUCCESS) {
        printf("SPI set mode failed, status:%d\n", ret);
        goto EXIT;
    }
    
    spiCommand = 0x9F;
    memset(readBuffer, 0, 3);
    ret = SPIWriteRead(deviceHandle, SPI_SELECT_0, &spiCommand, 1, readBuffer, 3, &readBackLength, timeout_msec);
    if (ret != ERR_HID_SUCCESS) {
        printf("SPI Read Identification(RDID) failed, status:%d\n", ret);
        goto EXIT;
    } else {
        printf("SPI ManufactureID:0x%x, MemoryType:0x%x, MemoryDenisty:0x%x\n", readBuffer[0], readBuffer[1], readBuffer[2]);
    }
    
    spiCommand = 0x05;
    memset(readBuffer, 0, 3);
    ret = SPIWriteRead(deviceHandle, SPI_SELECT_0, &spiCommand, 1, readBuffer, 1, &readBackLength, timeout_msec);
    if (ret != ERR_HID_SUCCESS) {
        printf("SPI Read Status Register(RDSR) failed, status:%d\n", ret);
        goto EXIT;
    } else {
        printf("SPI Read Status Register Success - The Status:0x%x\n", readBuffer[0]);
    }
    
    spiCommand = 0x06;
    memset(readBuffer, 0, 3);
    ret = SPIWrite(deviceHandle, SPI_SELECT_0, &spiCommand, 1, &writtenLength);
    if (ret != ERR_HID_SUCCESS) {
        printf("SPI Send write Enable failed, status:%d\n", ret);
        goto EXIT;
    } else {
        printf("SPI Send write Enable Success\n");
    }
    
EXIT:
    ret = CloseDeviceHandle(deviceHandle);
    FreeDeviceHandleList(&deviceHandleList);
    ExitDevice();
    
    return 0;
}
