#include <stdio.h>
#include <unistd.h>
#include "HidSdkApi.h"

int main() {
    HANDLE *deviceHandleList = NULL;
    uint8_t deviceCount = 0;
    int32_t ret = ERR_HID_SUCCESS;
    HANDLE *deviceHandle = NULL;
    uint32_t timeout_msec = 1000;
    uint8_t slaveDeviceAddress = 0xA0;
    uint8_t currentFreqDiv = 59; // I2C freq(KHz) = 96000/((currentFreqDiv*2+1)*2) = 403 Khz
    uint16_t writtenLength = 0;
    uint16_t readBackLength = 0;
    uint32_t delay_us = 5*1000; // 5ms
    uint32_t sdkVersion = 0;
    
    //Start Address: 0x0000
    uint8_t writeBuffer[12] = {0x00, 0x00, 'I', '2', 'C', 'S', 'a', 'm', 'p', 'l', 'e', '\0'};
    uint8_t readBuffer[10] = {0};
    
    GetSDKVersion(&sdkVersion);
    printf("SDK Version:0x%x\n", sdkVersion);
    
    ret = InitDevice();
    if (ret != ERR_HID_SUCCESS) {
        return -1;
    }
    
    ret = GetDeviceHandleListByVidPid(0x67b, 0x2561, &deviceHandleList, &deviceCount);
    if (ret != ERR_HID_SUCCESS || deviceCount == 0) {
        printf("I2C get deivce handle list failed, status:%d, device count:%d\n", ret, deviceCount);
        return -1;
    }
    
    for (int i = 0; i < deviceCount; i++) {
        struct HIDDeviceInfo deviceInfo = {0};
        HANDLE *tempDeviceHandle = deviceHandleList[i];
        ret = GetDeviceInfo(tempDeviceHandle, &deviceInfo);
        if (ret != ERR_HID_SUCCESS) {
            printf("I2C get device info failed, status:%d\n", ret);
            goto EXIT;
        }
        if (deviceInfo.interfaceNumber == 1) {
            deviceHandle = tempDeviceHandle;
            break;
        }
    }
    
    if (deviceHandle == NULL) {
        printf("I2C  device handle not found\n");
        goto EXIT;
    }
    
    ret = OpenDeviceHandle(deviceHandle);
    if (ret != ERR_HID_SUCCESS) {
        printf("I2C open device handle failed, status:%d\n", ret);
        goto EXIT;
    }
    
    ret = SetI2CFrequency(deviceHandle, currentFreqDiv);
    if (ret != ERR_HID_SUCCESS) {
        printf("I2C Set I2C frequency failed, status:%d\n", ret);
        goto EXIT;
    }
    
    // I2C write
    // Start Address: 0x0000
    // Data : A string "I2CSample\0", \0 means NULL_character
    // Length : 10 bytes + 2 bytes Start Address
    ret = I2CWrite(deviceHandle, slaveDeviceAddress, writeBuffer, 12, &writtenLength);
    if (ret != ERR_HID_SUCCESS) {
        printf("I2C write failed, status:%d\n", ret);
        goto EXIT;
    }
    printf("I2C write data: %s\n", &writeBuffer[2]);
    
    // After the process of write, needs sleep to wait the i2c write is finished
    // The delay time is depended on the application
    usleep(delay_us);
    
    // Write address first, and then, read data
    // Start Address: 0x0000
    // Length: 10 bytes
    writeBuffer[0] = 0x00;
    writeBuffer[1] = 0x00;
    ret = I2CWriteRead(deviceHandle, slaveDeviceAddress, writeBuffer, 2, readBuffer, 10, &readBackLength, timeout_msec);
    if (ret != ERR_HID_SUCCESS) {
        printf("I2C read failed, status:%d\n", ret);
        goto EXIT;
    } else {
        printf("I2C read data: %s\n", readBuffer);
    }
    
EXIT:
    ret = CloseDeviceHandle(deviceHandle);
    FreeDeviceHandleList(&deviceHandleList);
    ExitDevice();
    
    return 0;
}
